/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationFunctions {
    private static Logger logger = LoggerFactory.getLogger(AnnotationFunctions.class);

    public static Optional<Annotation> getAnnotation(Class<?> type, String annotationFullyQualifiedName) {
        return Arrays.stream(type.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst();
    }

    public static Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        return Arrays.stream(methods).filter(f -> fieldName.equals(f.getName())).findFirst().map(f -> {
            try {
                return f.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to get value of annotation " + annotation.annotationType());
                return null;
            }
        });
    }
}

