/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.cache;

import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageType;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cache.CacheManager;

public class CacheStorageScanner
extends AbstractRuntimeScanner {
    private final ScanApplicationContext context;

    public CacheStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        this.getCacheStorage().ifPresent(cacheStorage -> data.addStorages(Collections.singletonList(cacheStorage)));
    }

    private Optional<Storage> getCacheStorage() {
        Map<String, ?> beanMap = this.context.getBeansOfType("org.springframework.cache.CacheManager");
        if (beanMap.isEmpty()) {
            return Optional.empty();
        }
        Set cacheNames = beanMap.values().stream().map(this::getCacheNames).filter(col -> !col.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
        if (cacheNames.isEmpty()) {
            return Optional.empty();
        }
        if (cacheNames.size() == 1 && cacheNames.contains("CachingServiceInstanceListSupplierCache")) {
            return Optional.empty();
        }
        Storage mergedCaches = new Storage();
        mergedCaches.setCache(true);
        mergedCaches.setType(StorageType.CACHE);
        mergedCaches.setName("Cache");
        mergedCaches.addProperty("Cache-names", cacheNames.stream().collect(Collectors.joining(", ")));
        return Optional.of(mergedCaches);
    }

    private Collection<String> getCacheNames(CacheManager cacheManager) {
        try {
            Collection cacheNames = cacheManager.getCacheNames();
            if (cacheNames == null || cacheNames.isEmpty()) {
                return Collections.emptyList();
            }
            return cacheNames;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

