/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.rabbitmq;

import io.contextmap.annotations.ContextEvent;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.reflection.AnnotatedTypeScanner;
import io.contextmap.spring.runtime.reflection.AnnotationFunctions;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMQScanner
extends AbstractRuntimeScanner {
    private static Logger logger = LoggerFactory.getLogger(RabbitMQScanner.class);
    private final ScanApplicationContext context;

    public RabbitMQScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, String> subscribedExchanges = this.getSubscribedExchanges();
        Set<Event> publishedEvents = this.getPublishedExchanges(subscribedExchanges);
        data.setPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
        Set<Event> subscribedEvents = subscribedExchanges.keySet().stream().map(Event::new).collect(Collectors.toSet());
        data.setSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
    }

    private Map<String, String> getSubscribedExchanges() {
        Map<String, ?> bindingBeans = this.context.getBeansOfType("org.springframework.amqp.core.Binding");
        if (bindingBeans.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> subscribedExchanges = new HashMap<String, String>();
        bindingBeans.values().stream().forEach(b -> {
            Binding binding = (Binding)b;
            String exchangeName = binding.getExchange();
            String virtualHostName = this.getVirtualHost((Declarable)binding);
            subscribedExchanges.put(this.formatName(virtualHostName, exchangeName), binding.getDestination());
        });
        return subscribedExchanges;
    }

    private Set<Event> getPublishedExchanges(Map<String, String> subscribedExchanges) {
        HashSet<String> publishedExchanges = new HashSet<String>();
        publishedExchanges.addAll(this.getPublishedExchangesFromExchanges(subscribedExchanges));
        publishedExchanges.addAll(this.getPublishedExchangesFromRabbitTemplates(subscribedExchanges));
        Map<String, Event> publishedEvents = publishedExchanges.stream().map(Event::new).collect(Collectors.toMap(Event::getName, e -> e));
        AnnotatedTypeScanner contextEventScanner = new AnnotatedTypeScanner(ContextEvent.class);
        Set<Class<?>> typesAnnotatedWithContextEvent = contextEventScanner.findTypes(this.context.getComponentScanPackages());
        HashMap eventClassToPublishers = new HashMap();
        for (Class<?> eventClass : typesAnnotatedWithContextEvent) {
            Optional<Object> publishedByOptional;
            Optional<Annotation> annotation = AnnotationFunctions.getAnnotation(eventClass, ContextEvent.class.getName());
            if (!annotation.isPresent() || !(publishedByOptional = AnnotationFunctions.getAnnotationFieldValue(annotation.get(), "publishedBy")).isPresent()) continue;
            HashSet publishedByExchangeNames = new HashSet();
            eventClassToPublishers.put(eventClass, publishedByExchangeNames);
            String[] publishedBy = (String[])publishedByOptional.get();
            Arrays.stream(publishedBy).filter(Objects::nonNull).filter(n -> !n.isEmpty()).map(beanName -> this.resolveExchangeNameFromPublishedByName(eventClass, (String)beanName)).filter(publishedByExchangeName -> publishedByExchangeName != null && !publishedByExchangeName.isEmpty()).forEach(publishedByExchangeNames::add);
        }
        EventFunctions.addPayloadsToEvents(eventClassToPublishers, publishedEvents);
        return new HashSet<Event>(publishedEvents.values());
    }

    private String resolveExchangeNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        Optional<Object> optionalBean = this.context.getBeanByName(publishedByName);
        if (optionalBean.isPresent()) {
            Object bean = optionalBean.get();
            if (bean instanceof Exchange) {
                return this.getNameOfExchange((Exchange)bean);
            }
            if (bean instanceof RabbitTemplate) {
                return this.getNameOfExchange((RabbitTemplate)bean);
            }
            logger.error("Unable to extract exchange name of ContextEvent {} since the bean is not a RabbitTemplate or Exchange, but it's of type {}", eventClass, bean.getClass());
            return "";
        }
        return this.context.resolveSpELStringValue(publishedByName);
    }

    private Set<String> getPublishedExchangesFromExchanges(Map<String, String> subscribedExchanges) {
        Map<String, ?> exchangeBeans = this.context.getBeansOfType("org.springframework.amqp.core.Exchange");
        if (exchangeBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> publishedExchanges = new HashSet<String>();
        exchangeBeans.values().forEach(ex -> {
            Exchange exchange = (Exchange)ex;
            String exchangeName = exchange.getName();
            String fullname = this.getNameOfExchange(exchange);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                publishedExchanges.add(fullname);
            }
        });
        return publishedExchanges;
    }

    private String getNameOfExchange(Exchange exchange) {
        String exchangeName = exchange.getName();
        String virtualHostName = this.getVirtualHost((Declarable)exchange);
        return this.formatName(virtualHostName, exchangeName);
    }

    private String getNameOfExchange(RabbitTemplate rabbitTemplate) {
        String exchangeName = rabbitTemplate.getExchange();
        String virtualHostName = this.getVirtualHost(rabbitTemplate);
        return this.formatName(virtualHostName, exchangeName);
    }

    private Set<String> getPublishedExchangesFromRabbitTemplates(Map<String, String> subscribedExchanges) {
        Map<String, ?> rabbiteTemplateBeans = this.context.getBeansOfType("org.springframework.amqp.rabbit.core.RabbitTemplate");
        if (rabbiteTemplateBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> publishedExchanges = new HashSet<String>();
        rabbiteTemplateBeans.values().forEach(tmpl -> {
            RabbitTemplate rabbitTemplate = (RabbitTemplate)tmpl;
            String exchangeName = rabbitTemplate.getExchange();
            String fullname = this.getNameOfExchange(rabbitTemplate);
            if (!subscribedExchanges.containsKey(fullname) && exchangeName != null && !exchangeName.isEmpty()) {
                publishedExchanges.add(fullname);
            }
        });
        return publishedExchanges;
    }

    private String getVirtualHost(Declarable declarable) {
        Object admin;
        if (declarable.getDeclaringAdmins() != null && !declarable.getDeclaringAdmins().isEmpty() && (admin = declarable.getDeclaringAdmins().iterator().next()) instanceof RabbitAdmin) {
            return this.getVirtualHost(((RabbitAdmin)admin).getRabbitTemplate());
        }
        return "";
    }

    private String getVirtualHost(RabbitTemplate rabbitTemplate) {
        return rabbitTemplate.getConnectionFactory().getVirtualHost();
    }

    private String formatName(String virtualHost, String exchangeOrQueue) {
        if (virtualHost == null || virtualHost.trim().isEmpty()) {
            return "/:" + exchangeOrQueue;
        }
        return virtualHost + ":" + exchangeOrQueue;
    }
}

