/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events;

import io.contextmap.annotations.ContextEvent;
import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.core.reflection.ReflectionFunctions;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.reflection.AnnotatedTypeScanner;
import io.contextmap.spring.runtime.reflection.AnnotationFunctions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFunctions {
    private static final Logger logger = LoggerFactory.getLogger(EventFunctions.class);

    public static Map<Class<?>, Set<PayloadExchangeProperties>> getPayloadProperties(ScanApplicationContext context, BiFunction<Class, String, String> nameResolver) {
        AnnotatedTypeScanner contextEventScanner = new AnnotatedTypeScanner(ContextEvent.class);
        Set<Class<?>> typesAnnotatedWithContextEvent = contextEventScanner.findTypes(context.getComponentScanPackages());
        HashMap eventClassToPublishers = new HashMap();
        for (Class<?> eventClass : typesAnnotatedWithContextEvent) {
            Optional<Object> publishedByOptional;
            Optional<Annotation> annotation = AnnotationFunctions.getAnnotation(eventClass, ContextEvent.class.getName());
            if (!annotation.isPresent() || !(publishedByOptional = AnnotationFunctions.getAnnotationFieldValue(annotation.get(), "publishedBy")).isPresent()) continue;
            HashSet publishedByExchangeProperties = new HashSet();
            eventClassToPublishers.put(eventClass, publishedByExchangeProperties);
            String[] publishedBy = (String[])publishedByOptional.get();
            Arrays.stream(publishedBy).filter(Objects::nonNull).filter(n -> !n.isEmpty()).forEach(beanName -> {
                String publishedByExchangeName = (String)nameResolver.apply(eventClass, (String)beanName);
                if (publishedByExchangeName != null && !publishedByExchangeName.isEmpty()) {
                    PayloadExchangeProperties properties = new PayloadExchangeProperties(publishedByExchangeName);
                    publishedByExchangeProperties.add(properties);
                }
            });
        }
        return eventClassToPublishers;
    }

    public static void addPayloadsToEvents(Map<Class<?>, Set<PayloadExchangeProperties>> eventClassToPublishers, Map<String, Event> publishedEvents) {
        eventClassToPublishers.forEach((eventClass, exchangePropertiesSet) -> {
            Property property = new Property("", null, null, null, eventClass);
            List typesToExcludeToPreventLoop = Collections.emptyList();
            ObjectToJsonConverter.ObjectToJsonReflection objectToJsonReflection = new ObjectToJsonConverter.ObjectToJsonReflection(){

                public Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
                    return ReflectionFunctions.getAnnotationFieldValue((Annotation)annotation, (String)fieldName);
                }

                public Optional<Annotation> getAnnotation(Method method, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Method)method, (String)annotationFullyQualifiedName);
                }

                public Optional<Annotation> getAnnotation(Field field, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Field)field, (String)annotationFullyQualifiedName);
                }
            };
            ObjectToJsonConverter.ObjectToJsonLogger objectToJsonLogger = new ObjectToJsonConverter.ObjectToJsonLogger(){

                public void debug(CharSequence message) {
                    logger.debug(message.toString());
                }

                public void info(CharSequence message) {
                    logger.info(message.toString());
                }

                public void warn(CharSequence message) {
                    logger.warn(message.toString());
                }
            };
            ObjectToJsonConverter converter = new ObjectToJsonConverter(objectToJsonReflection, objectToJsonLogger);
            ScannedJsonNode resulingJson = converter.serializedJson(eventClass, property, typesToExcludeToPreventLoop);
            exchangePropertiesSet.forEach(exchangeProperties -> {
                Event eventForExchange = (Event)publishedEvents.get(exchangeProperties.exchangeName);
                if (eventForExchange == null) {
                    eventForExchange = new Event(exchangeProperties.exchangeName, exchangeProperties.exchangeName);
                    eventForExchange.setAdhocCreatedFromPayload(true);
                    publishedEvents.put(exchangeProperties.exchangeName, eventForExchange);
                }
                eventForExchange.getPayloadsAsJsonNode().add(resulingJson);
            });
        });
    }

    public static class PayloadExchangeProperties {
        public final String exchangeName;
        public String routingKey;

        public PayloadExchangeProperties(String exchangeName) {
            this.exchangeName = exchangeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PayloadExchangeProperties that = (PayloadExchangeProperties)o;
            return this.exchangeName.equals(that.exchangeName);
        }

        public int hashCode() {
            return Objects.hash(this.exchangeName);
        }
    }
}

