/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.jms;

import io.contextmap.annotations.ContextEvent;
import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.reflection.AnnotatedTypeScanner;
import io.contextmap.spring.runtime.reflection.AnnotationFunctions;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public class ActiveMQJmsScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(ActiveMQJmsScanner.class);
    private final ScanApplicationContext context;

    public ActiveMQJmsScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        logger.info("Scanning JMS events");
        Set<Event> subscribedEvents = this.getSubscribedQueues();
        data.addSubscribedEvents(subscribedEvents);
        data.getExecution().setScannedSubscribedEvents(true);
        Set<Event> publishedEvents = this.getPublishedQueues();
        data.addPublishedEvents(publishedEvents);
        data.getExecution().setScannedPublishedEvents(true);
    }

    private Set<Event> getSubscribedQueues() {
        HashSet queueNames = new HashSet();
        Map<String, ?> registries = this.context.getBeansOfType("org.springframework.jms.config.JmsListenerEndpointRegistry");
        if (registries.isEmpty()) {
            return Collections.emptySet();
        }
        for (Object registryObj : registries.values()) {
            JmsListenerEndpointRegistry registry = (JmsListenerEndpointRegistry)registryObj;
            registry.getListenerContainers().forEach(listenerContainer -> {
                if (listenerContainer instanceof AbstractMessageListenerContainer) {
                    AbstractMessageListenerContainer abCont = (AbstractMessageListenerContainer)listenerContainer;
                    queueNames.add(abCont.getDestinationName());
                }
            });
        }
        return queueNames.stream().map(name -> new Event((String)name, (String)name)).collect(Collectors.toSet());
    }

    private Optional<String> getQueueName(Object object) {
        try {
            Method method = object.getClass().getDeclaredMethod("getQueueName", new Class[0]);
            Object result = method.invoke(object, new Object[0]);
            if (result == null) {
                return Optional.empty();
            }
            return Optional.of((String)result);
        }
        catch (Throwable t) {
            logger.warn("Problem occurred while getting queue name: " + t.getMessage());
            return Optional.empty();
        }
    }

    private Set<Event> getPublishedQueues() {
        HashMap<String, Event> publishedEvents = new HashMap<String, Event>();
        this.getPublishedQueuesFromJmsTemplates().forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        this.getPublishedQueuesFromQueues().forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        this.getPublishedQueuesFromTopics().forEach(e -> publishedEvents.put(e.getName(), (Event)e));
        AnnotatedTypeScanner contextEventScanner = new AnnotatedTypeScanner(ContextEvent.class);
        Set<Class<?>> typesAnnotatedWithContextEvent = contextEventScanner.findTypes(this.context.getComponentScanPackages());
        HashMap eventClassToPublishers = new HashMap();
        for (Class<?> eventClass : typesAnnotatedWithContextEvent) {
            Optional<Object> publishedByOptional;
            Optional<Annotation> annotation = AnnotationFunctions.getAnnotation(eventClass, ContextEvent.class.getName());
            if (!annotation.isPresent() || !(publishedByOptional = AnnotationFunctions.getAnnotationFieldValue(annotation.get(), "publishedBy")).isPresent()) continue;
            HashSet publishedByExchangeNames = new HashSet();
            eventClassToPublishers.put(eventClass, publishedByExchangeNames);
            String[] publishedBy = (String[])publishedByOptional.get();
            Arrays.stream(publishedBy).filter(Objects::nonNull).filter(n -> !n.isEmpty()).map(beanName -> this.resolveExchangeNameFromPublishedByName(eventClass, (String)beanName)).filter(publishedByExchangeName -> publishedByExchangeName != null && !publishedByExchangeName.isEmpty()).map(EventFunctions.PayloadExchangeProperties::new).forEach(publishedByExchangeNames::add);
        }
        EventFunctions.addPayloadsToEvents(eventClassToPublishers, publishedEvents);
        return new HashSet<Event>(publishedEvents.values());
    }

    private Set<Event> getPublishedQueuesFromTopics() {
        HashSet<Event> events = new HashSet<Event>();
        Set<String> topicNames = this.getDestinationNamesOfType("javax.jms.Topic", "jakarta.jms.Topic");
        topicNames.forEach(n -> {
            Event e = new Event((String)n, (String)n);
            e.addPropertyIfValueNotBlank("Message Broker", "JMS");
            e.addPropertyIfValueNotBlank("Type", "topic");
            events.add(e);
        });
        return events;
    }

    private Set<Event> getPublishedQueuesFromQueues() {
        HashSet<Event> events = new HashSet<Event>();
        Set<String> queueNames = this.getDestinationNamesOfType("javax.jms.Queue", "jakarta.jms.Queue");
        queueNames.forEach(n -> {
            Event e = new Event((String)n, (String)n);
            e.addPropertyIfValueNotBlank("Message Broker", "JMS");
            e.addPropertyIfValueNotBlank("Type", "queue");
            events.add(e);
        });
        return events;
    }

    private Set<Event> getPublishedQueuesFromJmsTemplates() {
        Map<String, ?> jmsTemplateBeans = this.context.getBeansOfType("org.springframework.jms.core.JmsTemplate");
        if (jmsTemplateBeans.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Event> events = new HashSet<Event>();
        jmsTemplateBeans.values().forEach(tmpl -> {
            JmsTemplate jmsTemplate = (JmsTemplate)tmpl;
            this.getJmsTemplateQueueName(jmsTemplate).ifPresent(n -> {
                if (!n.isEmpty()) {
                    Event e = new Event((String)n, (String)n);
                    e.addPropertyIfValueNotBlank("Message Broker", "JMS");
                    events.add(e);
                }
            });
        });
        return events;
    }

    private Optional<String> getJmsTemplateQueueName(JmsTemplate jmsTemplate) {
        String name = jmsTemplate.getDefaultDestinationName();
        if (name != null && !name.isEmpty()) {
            return Optional.of(name);
        }
        if (jmsTemplate.getDefaultDestination() != null) {
            return this.getQueueName(jmsTemplate.getDefaultDestination());
        }
        return Optional.empty();
    }

    private String resolveExchangeNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        Optional<Object> optionalBean = this.context.getBeanByName(publishedByName);
        if (optionalBean.isPresent()) {
            try {
                Object bean = optionalBean.get();
                if (bean instanceof JmsTemplate) {
                    return this.getJmsTemplateQueueName((JmsTemplate)bean).orElse("");
                }
                return this.getQueueName(bean).orElse("");
            }
            catch (Exception e) {
                logger.error("Unexpected error while scanning ActiveMQ");
                return "";
            }
        }
        return this.context.resolveSpELStringValue(publishedByName);
    }

    private Set<String> getDestinationNamesOfType(String ... fullyQualifiedNames) {
        HashSet<String> queueNames = new HashSet<String>();
        for (String fullyQualifiedName : fullyQualifiedNames) {
            Map<String, ?> queues = this.context.getBeansOfType(fullyQualifiedName);
            queues.values().forEach(q -> this.getQueueName(q).ifPresent(queueNames::add));
        }
        return queueNames;
    }
}

