/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.rabbitmq;

import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public abstract class AbstractRabbitMQScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRabbitMQScanner.class);
    protected final ScanApplicationContext context;

    protected AbstractRabbitMQScanner(ScanApplicationContext context) {
        this.context = context;
    }

    protected String getNameOfExchange(RabbitTemplate rabbitTemplate) {
        String exchangeName = rabbitTemplate.getExchange();
        String virtualHostName = this.getVirtualHost(rabbitTemplate);
        return this.formatName(virtualHostName, exchangeName);
    }

    protected String getVirtualHost(RabbitTemplate rabbitTemplate) {
        return rabbitTemplate.getConnectionFactory().getVirtualHost();
    }

    protected String formatName(String virtualHost, String exchangeOrQueue) {
        return this.formatVirtualHost(virtualHost) + ":" + exchangeOrQueue;
    }

    protected String formatVirtualHost(String virtualHost) {
        if (virtualHost == null || virtualHost.trim().isEmpty()) {
            String defaultVH = this.context.getParameters().getDefaultRabbitVirtualHost();
            if (defaultVH != null && !defaultVH.trim().isEmpty()) {
                return defaultVH;
            }
            return "/";
        }
        return virtualHost;
    }

    protected void addPropertiesToEventFromRabbitTemplate(Event event, RabbitTemplate rabbitTemplate, String exchangeName) {
        event.addPropertyIfValueNotBlank("Message Broker", "RabbitMQ");
        event.addPropertyIfValueNotBlank("Exchange Name", exchangeName);
        event.addPropertyIfValueNotBlank("Virtual Host", this.formatVirtualHost(this.getVirtualHost(rabbitTemplate)));
        event.addPropertyIfValueNotBlank("Host", rabbitTemplate.getConnectionFactory().getHost());
        event.addPropertyIfValueNotBlank("Username", rabbitTemplate.getConnectionFactory().getUsername());
        event.addPropertyIfValueNotBlank("Port", String.valueOf(rabbitTemplate.getConnectionFactory().getPort()));
    }

    protected String resolveExchangeNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        Optional<Object> optionalBean = this.context.getBeanByName(publishedByName);
        if (optionalBean.isPresent()) {
            Object bean = optionalBean.get();
            if (bean instanceof Exchange) {
                return this.getNameOfExchange((Exchange)bean);
            }
            if (bean instanceof RabbitTemplate) {
                return this.getNameOfExchange((RabbitTemplate)bean);
            }
            logger.warn("Unable to extract exchange name of ContextEvent {} since the bean is not a RabbitTemplate or Exchange, but it's of type {}", eventClass, bean.getClass());
            return "";
        }
        return this.context.resolveSpELStringValue(publishedByName);
    }

    protected String getNameOfExchange(Exchange exchange) {
        String exchangeName = exchange.getName();
        String virtualHostName = this.getVirtualHost((Declarable)exchange);
        return this.formatName(virtualHostName, exchangeName);
    }

    protected String getVirtualHost(Declarable declarable) {
        return this.getRabbitAdmin(declarable).map(RabbitAdmin::getRabbitTemplate).map(this::getVirtualHost).orElse("");
    }

    protected Optional<RabbitAdmin> getRabbitAdmin(Declarable declarable) {
        Object admin;
        if (declarable.getDeclaringAdmins() != null && !declarable.getDeclaringAdmins().isEmpty() && (admin = declarable.getDeclaringAdmins().iterator().next()) instanceof RabbitAdmin) {
            return Optional.of((RabbitAdmin)admin);
        }
        return Optional.empty();
    }
}

