/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner;

import io.contextmap.spring.runtime.model.Scan;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuntimeScanner.class);

    public abstract void scan(Scan var1);

    protected void runWithMaxDurationBeforeTimeout(int maxDurationSeconds, Runnable runnable, String errorMessage) {
        if (maxDurationSeconds <= 0) {
            maxDurationSeconds = 30;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(runnable);
        try {
            future.get(maxDurationSeconds, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            logger.warn("*** Failed to " + errorMessage + ", due to " + e.getMessage());
            logger.warn("*** If this would cause unwanted side-effects, then you may want to opt to disable this scan.");
            logger.debug("Caught exception", e);
            future.cancel(true);
        }
        try {
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

