/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.kafka;

import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.BindingService;

public class KafkaCloudStreamScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(KafkaCloudStreamScanner.class);
    private final ScanApplicationContext context;

    public KafkaCloudStreamScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        Map<String, ?> bindingServiceBeans = this.context.getBeansOfType("org.springframework.cloud.stream.binding.BindingService");
        if (bindingServiceBeans.isEmpty()) {
            return;
        }
        logger.info("Scanning Kafka events (Cloud Stream)");
        data.getExecution().setScannedPublishedEvents(true);
        data.getExecution().setScannedSubscribedEvents(true);
        for (Object bindingService : bindingServiceBeans.values()) {
            try {
                Set<Event> outputs = this.reflectOutputs((BindingService)bindingService);
                data.addPublishedEvents(outputs);
                Set<Event> inputs = this.reflectInputs((BindingService)bindingService);
                data.addSubscribedEvents(inputs);
            }
            catch (Throwable e) {
                logger.warn("Problem detected while scanning kafka: {}", (Object)e.getMessage());
            }
        }
    }

    private Set<Event> reflectOutputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("producerBindings");
        field.setAccessible(true);
        Map producerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (Binding binding : producerBindings.values()) {
            String name = binding.getName();
            if (name == null || name.isEmpty()) continue;
            Event event = new Event(name, name);
            event.addPropertyIfValueNotBlank("Message Broker", "Kafka");
            event.addPropertyIfValueNotBlank("Topic Name", name);
            events.add(event);
            HashMap<String, Event> eventWrappedInMap = new HashMap<String, Event>();
            eventWrappedInMap.put(event.getName(), event);
            Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveNameFromPublishedByName);
            EventFunctions.addPayloadsToEvents(eventClassToPublishers, eventWrappedInMap);
        }
        return events;
    }

    private Set<Event> reflectInputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("consumerBindings");
        field.setAccessible(true);
        Map consumerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (List bindings : consumerBindings.values()) {
            for (Binding binding : bindings) {
                String name = binding.getName();
                events.add(new Event(name, name));
            }
        }
        return events;
    }

    protected String resolveNameFromPublishedByName(Class<?> eventClass, String publishedByName) {
        return this.context.resolveSpELStringValue(publishedByName);
    }
}

