/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events.rabbitmq;

import io.contextmap.spring.runtime.model.Event;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.scanner.events.EventFunctions;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.AbstractRabbitMQScanner;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.context.Lifecycle;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint;

public class RabbitMQCloudStreamScanner
extends AbstractRabbitMQScanner {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQCloudStreamScanner.class);

    public RabbitMQCloudStreamScanner(ScanApplicationContext context) {
        super(context);
    }

    @Override
    public void scan(Scan data) {
        Map<String, ?> bindingServiceBeans = this.context.getBeansOfType("org.springframework.cloud.stream.binding.BindingService");
        if (bindingServiceBeans.isEmpty()) {
            return;
        }
        logger.info("Scanning RabbitMQ events (Cloud Stream)");
        data.getExecution().setScannedPublishedEvents(true);
        data.getExecution().setScannedSubscribedEvents(true);
        for (Object bindingService : bindingServiceBeans.values()) {
            try {
                Set<Event> outputs = this.reflectOutputs((BindingService)bindingService);
                data.addPublishedEvents(outputs);
                Set<Event> inputs = this.reflectInputs((BindingService)bindingService);
                data.addSubscribedEvents(inputs);
            }
            catch (Throwable e) {
                logger.warn("Problem detected while scanning rabbitmq: {}", (Object)e.getMessage());
            }
        }
    }

    private Set<Event> reflectOutputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("producerBindings");
        field.setAccessible(true);
        Map producerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (Binding binding : producerBindings.values()) {
            String exchangeName = binding.getName();
            String virtualHost = null;
            RabbitTemplate rabbitTemplate = null;
            if (binding instanceof DefaultBinding) {
                DefaultBinding defaultBinding = (DefaultBinding)binding;
                field = DefaultBinding.class.getDeclaredField("lifecycle");
                field.setAccessible(true);
                Lifecycle lifecycle = (Lifecycle)field.get(defaultBinding);
                if (lifecycle instanceof AmqpOutboundEndpoint) {
                    AmqpOutboundEndpoint outboundEndpoint = (AmqpOutboundEndpoint)lifecycle;
                    field = AmqpOutboundEndpoint.class.getDeclaredField("amqpTemplate");
                    field.setAccessible(true);
                    AmqpTemplate amqpTemplate = (AmqpTemplate)field.get(outboundEndpoint);
                    if (amqpTemplate instanceof RabbitTemplate) {
                        rabbitTemplate = (RabbitTemplate)amqpTemplate;
                        virtualHost = this.getVirtualHost(rabbitTemplate);
                    }
                }
            }
            String fullName = this.formatName(virtualHost, exchangeName);
            Event event = new Event(fullName, exchangeName);
            events.add(event);
            HashMap<String, Event> eventWrappedInMap = new HashMap<String, Event>();
            eventWrappedInMap.put(event.getName(), event);
            eventWrappedInMap.put(exchangeName, event);
            Map<Class<?>, Set<EventFunctions.PayloadExchangeProperties>> eventClassToPublishers = EventFunctions.getPayloadProperties(this.context, this::resolveExchangeNameFromPublishedByName);
            EventFunctions.addPayloadsToEvents(eventClassToPublishers, eventWrappedInMap);
            if (rabbitTemplate == null) continue;
            this.addPropertiesToEventFromRabbitTemplate(event, rabbitTemplate, exchangeName);
        }
        return events;
    }

    private Set<Event> reflectInputs(BindingService bindingService) throws Exception {
        Field field = BindingService.class.getDeclaredField("consumerBindings");
        field.setAccessible(true);
        Map consumerBindings = (Map)field.get(bindingService);
        HashSet<Event> events = new HashSet<Event>();
        for (List bindings : consumerBindings.values()) {
            for (Binding binding : bindings) {
                String exchangeName = binding.getName();
                String virtualHost = null;
                if (binding instanceof DefaultBinding) {
                    DefaultBinding defaultBinding = (DefaultBinding)binding;
                    field = DefaultBinding.class.getDeclaredField("lifecycle");
                    field.setAccessible(true);
                    Lifecycle lifecycle = (Lifecycle)field.get(defaultBinding);
                    if (lifecycle instanceof AmqpInboundChannelAdapter) {
                        AmqpInboundChannelAdapter inboundChannelAdapter = (AmqpInboundChannelAdapter)lifecycle;
                        field = AmqpInboundChannelAdapter.class.getDeclaredField("messageListenerContainer");
                        field.setAccessible(true);
                        AbstractMessageListenerContainer messageListenerContainer = (AbstractMessageListenerContainer)field.get(inboundChannelAdapter);
                        ConnectionFactory connectionFactory = messageListenerContainer.getConnectionFactory();
                        if (connectionFactory != null) {
                            virtualHost = connectionFactory.getVirtualHost();
                        }
                    }
                }
                String fullName = this.formatName(virtualHost, exchangeName);
                events.add(new Event(fullName, exchangeName));
            }
        }
        return events;
    }
}

