/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import io.contextmap.core.reflection.ScannedJsonNodeMerger;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageEntity;
import io.contextmap.spring.runtime.model.storage.StorageEntityType;
import io.contextmap.spring.runtime.scanner.storage.mongodb.DocumentToJsonConverter;
import java.util.ArrayList;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoTemplateMetadataScanner {
    public static final int MAX_NR_OF_COLLECTIONS = 100;
    public static final int MAX_NR_OF_SAMPLES = 100;
    private static final Logger logger = LoggerFactory.getLogger(MongoTemplateMetadataScanner.class);

    public static void enrichMongoWithMetadata(Storage storage, MongoTemplate mongoTemplate) {
        ArrayList<StorageEntity> entities = new ArrayList<StorageEntity>();
        storage.setEntities(entities);
        try {
            mongoTemplate.execute(db -> {
                for (String collectionName : db.listCollectionNames()) {
                    if (entities.size() >= 100) {
                        return null;
                    }
                    logger.debug("Found collection " + collectionName);
                    StorageEntity entity = MongoTemplateMetadataScanner.createCollectionEntity(collectionName);
                    entities.add(entity);
                    ScannedJsonNode analysis = MongoTemplateMetadataScanner.analyzeSchema(collectionName, mongoTemplate);
                    entity.setSchemaAnalysis(analysis);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.debug("Error: " + e.getMessage());
        }
    }

    private static ScannedJsonNode analyzeSchema(String collectionName, MongoTemplate mongoTemplate) {
        ScannedJsonNodeMerger merger = new ScannedJsonNodeMerger();
        mongoTemplate.execute(collectionName, collection -> {
            Document document = null;
            FindIterable results = collection.find();
            results.limit(100);
            try (MongoCursor iterDoc = results.iterator();){
                while (iterDoc.hasNext()) {
                    document = (Document)iterDoc.next();
                    ScannedJsonNode scannedJsonNode = DocumentToJsonConverter.toScannedJsonNode(document);
                    merger.merge(scannedJsonNode);
                }
            }
            return document;
        });
        return merger.getMergeResult();
    }

    public static StorageEntity createCollectionEntity(String collectionName) {
        StorageEntity entity = new StorageEntity();
        entity.setName(collectionName);
        entity.setType(StorageEntityType.COLLECTION);
        return entity;
    }
}

