/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime;

import io.contextmap.spring.runtime.http.SendClient;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.ScanExecution;
import io.contextmap.spring.runtime.model.ScannedComponent;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import io.contextmap.spring.runtime.scanner.NameScanner;
import io.contextmap.spring.runtime.scanner.events.ObsoleteEventCleaner;
import io.contextmap.spring.runtime.scanner.events.azure.eventhub.AzureEventHubCloudStreamScanner;
import io.contextmap.spring.runtime.scanner.events.azure.eventhub.AzureEventHubScanner;
import io.contextmap.spring.runtime.scanner.events.azure.servicebus.AzureServiceBusCloudStreamScanner;
import io.contextmap.spring.runtime.scanner.events.jms.ActiveMQJmsScanner;
import io.contextmap.spring.runtime.scanner.events.kafka.KafkaCloudStreamScanner;
import io.contextmap.spring.runtime.scanner.events.kafka.KafkaScanner;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.RabbitMQCloudStreamScanner;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.RabbitMQIntegrationFlowScanner;
import io.contextmap.spring.runtime.scanner.events.rabbitmq.RabbitMQScanner;
import io.contextmap.spring.runtime.scanner.storage.cache.CacheStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.contextmap.ContextStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.cosmosdb.CosmosStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.elastic.ElasticStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.jdbc.JdbcStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.mongodb.MongoStorageScanner;
import io.contextmap.spring.runtime.scanner.storage.solr.SolrStorageScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class ScanAtStartup
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ScanAtStartup.class);
    private final ScanApplicationContext applicationContext;
    private final List<AbstractRuntimeScanner> scanners;
    private static final Object LOCK = new Object();
    private static boolean scanned = false;

    public ScanAtStartup(ScanApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.scanners = this.createScanners();
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.applicationContext.getParameters().isScanningEnabled()) {
            logger.info("ContextMap runtime scan is not enabled. To enable configure property \"contextmap.enabled=true\"");
            return;
        }
        if (!this.applicationContext.getParameters().isKeyAvailable()) {
            return;
        }
        if (this.applicationContext.getApplicationId() == null || this.applicationContext.getApplicationId().isEmpty()) {
            logger.error("ContextMap is missing a required property: spring.application.name or contextmap.scan.component-name");
            return;
        }
        this.startScanThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScanThread() {
        Object object = LOCK;
        synchronized (object) {
            if (scanned) {
                logger.info("An additional scan request during startup was made but will be ignored.");
                return;
            }
            scanned = true;
            try {
                Thread scanThread = new Thread(this::scan, "contextmap-scan");
                scanThread.start();
            }
            catch (Throwable e) {
                logger.info("Error while scanning for metadata: " + e.getMessage());
            }
            finally {
                logger.debug("Finalized contextmap-scan thread");
            }
        }
    }

    private void scan() {
        logger.info("ContextMap is scanning for metadata...");
        Scan data = new Scan();
        data.setPluginName("io.contextmap.spring-runtime");
        data.setPluginVersion(this.getPluginVersion());
        data.setExecution(new ScanExecution());
        data.setScannedComponent(new ScannedComponent());
        this.scanners.forEach(scanner -> scanner.scan(data));
        if (this.applicationContext.getParameters().isDryRun()) {
            logger.info("ContextMap dry-run completed. Remember to disable dry-run to actually send the scan to the server.");
            return;
        }
        SendClient client = new SendClient(this.applicationContext);
        boolean success = client.send(data);
        if (success) {
            logger.info("ContextMap successfully scanned metadata");
        }
    }

    private String getPluginVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("contextmap-java-spring-runtime.properties"));
            String version = properties.getProperty("plugin.version");
            if (version == null || version.isEmpty()) {
                return "unknown version";
            }
            return version;
        }
        catch (Exception e) {
            return "unknown-version";
        }
    }

    private List<AbstractRuntimeScanner> createScanners() {
        ArrayList<AbstractRuntimeScanner> scanners = new ArrayList<AbstractRuntimeScanner>();
        scanners.add(new NameScanner(this.applicationContext));
        scanners.add(new JdbcStorageScanner(this.applicationContext));
        scanners.add(new CacheStorageScanner(this.applicationContext));
        scanners.add(new ContextStorageScanner(this.applicationContext));
        if (ScanAtStartup.isClassAvailable("org.springframework.amqp.core.Exchange")) {
            scanners.add(new RabbitMQScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.integration.dsl.StandardIntegrationFlow") && ScanAtStartup.isClassAvailable("org.springframework.integration.amqp.outbound.AmqpOutboundEndpoint")) {
            scanners.add(new RabbitMQIntegrationFlowScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.cloud.stream.binding.BindingService")) {
            if (ScanAtStartup.isClassAvailable("org.springframework.amqp.rabbit.core.RabbitTemplate")) {
                scanners.add(new RabbitMQCloudStreamScanner(this.applicationContext));
            }
            if (ScanAtStartup.isClassAvailable("com.azure.spring.messaging.servicebus.core.ServiceBusTemplate")) {
                scanners.add(new AzureServiceBusCloudStreamScanner(this.applicationContext));
            }
            if (ScanAtStartup.isClassAvailable("org.springframework.kafka.core.KafkaTemplate")) {
                scanners.add(new KafkaCloudStreamScanner(this.applicationContext));
            }
            if (ScanAtStartup.isClassAvailable("com.azure.spring.messaging.eventhubs.core.EventHubsTemplate")) {
                scanners.add(new AzureEventHubCloudStreamScanner(this.applicationContext));
            }
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.jms.core.JmsTemplate")) {
            scanners.add(new ActiveMQJmsScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.kafka.core.KafkaTemplate")) {
            scanners.add(new KafkaScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("com.azure.messaging.eventhubs.EventHubProducerClient")) {
            scanners.add(new AzureEventHubScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.data.mongodb.core.MongoTemplate")) {
            scanners.add(new MongoStorageScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("com.azure.spring.data.cosmos.core.CosmosTemplate")) {
            scanners.add(new CosmosStorageScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.elasticsearch.client.RestClient")) {
            scanners.add(new ElasticStorageScanner(this.applicationContext));
        }
        if (ScanAtStartup.isClassAvailable("org.springframework.data.solr.core.SolrTemplate")) {
            scanners.add(new SolrStorageScanner(this.applicationContext));
        }
        scanners.add(new ObsoleteEventCleaner());
        scanners.forEach(s -> logger.debug("Created scanner: " + s.getClass().getSimpleName()));
        return scanners;
    }

    public static boolean isClassAvailable(String className) {
        try {
            return Class.forName(className, false, ScanAtStartup.class.getClassLoader()) != null;
        }
        catch (Exception e) {
            logger.debug("Class NOT available: " + className);
            return false;
        }
    }
}

