/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.cosmosdb;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.spring.data.cosmos.core.CosmosTemplate;
import com.azure.spring.data.cosmos.core.ReactiveCosmosTemplate;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageType;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosStorageScanner
extends AbstractRuntimeScanner {
    private static final Logger logger = LoggerFactory.getLogger(CosmosStorageScanner.class);
    private final ScanApplicationContext context;

    public CosmosStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        logger.debug("Scanning CosmosDB storages");
        data.getExecution().setScannedStorages(true);
        data.addStorages(this.getCosmosStoragesFromTemplates());
        data.addStorages(this.getCosmosStoragesFromReactiveTemplates());
    }

    private List<Storage> getCosmosStoragesFromTemplates() {
        Map<String, ?> templates = this.context.getBeansOfType("com.azure.spring.data.cosmos.core.CosmosTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<Storage> getCosmosStoragesFromReactiveTemplates() {
        Map<String, ?> templates = this.context.getBeansOfType("com.azure.spring.data.cosmos.core.ReactiveCosmosTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Storage> convertToStorage(CosmosTemplate cosmosTemplate) {
        String dbName = this.reflectDatabaseName(cosmosTemplate);
        if (dbName == null || dbName.isEmpty()) {
            return Optional.empty();
        }
        Storage storage = new Storage();
        storage.setName(dbName);
        storage.setType(StorageType.COSMOSDB);
        storage.addProperty("Name", "CosmosDB");
        String serviceEndpoint = this.reflectServiceEndpoint(cosmosTemplate);
        if (serviceEndpoint != null && !serviceEndpoint.isEmpty()) {
            storage.addProperty("Service Endpoint", serviceEndpoint);
        }
        return Optional.of(storage);
    }

    private Optional<Storage> convertToStorage(ReactiveCosmosTemplate cosmosTemplate) {
        String dbName = this.reflectDatabaseName(cosmosTemplate);
        if (dbName == null || dbName.isEmpty()) {
            return Optional.empty();
        }
        Storage storage = new Storage();
        storage.setName(dbName);
        storage.setType(StorageType.COSMOSDB);
        storage.addProperty("Name", "CosmosDB");
        String serviceEndpoint = this.reflectServiceEndpoint(cosmosTemplate);
        if (serviceEndpoint != null && !serviceEndpoint.isEmpty()) {
            storage.addProperty("Service Endpoint", serviceEndpoint);
        }
        return Optional.of(storage);
    }

    private String reflectDatabaseName(Object template) {
        try {
            Field dbNameField = template.getClass().getDeclaredField("databaseName");
            dbNameField.setAccessible(true);
            return (String)dbNameField.get(template);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String reflectServiceEndpoint(Object template) {
        try {
            Field clientField = template.getClass().getDeclaredField("cosmosAsyncClient");
            clientField.setAccessible(true);
            CosmosAsyncClient client = (CosmosAsyncClient)clientField.get(template);
            if (client == null) {
                return null;
            }
            Field endpointField = client.getClass().getDeclaredField("serviceEndpoint");
            endpointField.setAccessible(true);
            return (String)endpointField.get(clientField);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

