/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.DiagramOverview;
import io.contextmap.scanner.decisionrecords.DiagramVisitor;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class DiagramsScanner {
    private static final int MAX_NR_OF_DIAGRAMS = 100;
    private final VersionControlLogger logger;

    public DiagramsScanner(VersionControlLogger logger) {
        this.logger = logger;
    }

    public List<DiagramOverview> scan(Path baseDir) {
        try {
            DiagramVisitor visitor = new DiagramVisitor(baseDir);
            Files.walkFileTree(baseDir, visitor);
            List<DiagramOverview> diagrams = visitor.getResults();
            if (diagrams.size() > 100) {
                this.logger.warn("Maximum number of diagrams is 100, some will be ignored");
                while (diagrams.size() > 100) {
                    diagrams.remove(0);
                }
            }
            return diagrams;
        }
        catch (Exception e) {
            this.logger.warn("Unable to scan for diagrams: " + e.getMessage());
            return Collections.emptyList();
        }
    }
}

