/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public abstract class AbstractFileVisitor<T>
extends SimpleFileVisitor<Path> {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private final Path baseDir;
    protected List<T> results = new ArrayList<T>();

    public AbstractFileVisitor(Path baseDir) {
        this.baseDir = baseDir;
    }

    public List<T> getResults() {
        return this.results;
    }

    protected abstract boolean isExtensionToInclude(String var1);

    protected abstract T convertToResult(Path var1) throws Exception;

    protected void addResult(Path file) throws Exception {
        this.results.add(this.convertToResult(file));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(attrs);
        if (dir.equals(this.baseDir)) {
            return FileVisitResult.CONTINUE;
        }
        Path pathToPotentialPomFile = dir.resolve("pom.xml");
        if (pathToPotentialPomFile.toFile().exists()) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (dir.toFile().getAbsolutePath().toLowerCase(Locale.US).contains("node_modules")) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
        try {
            FileVisitResult result = super.visitFile(file, attr);
            if (attr.isSymbolicLink() || !attr.isRegularFile()) {
                return result;
            }
            if (this.isExtensionToInclude(this.getExtension(file.getFileName().toString()))) {
                this.addResult(file);
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected String createContentHash(Path file) throws Exception {
        byte[] b = Files.readAllBytes(file);
        byte[] digest = MessageDigest.getInstance("MD5").digest(b);
        return this.printHexBinary(digest);
    }

    private String getExtension(String filename) {
        if (filename.contains(".")) {
            return filename.substring(filename.lastIndexOf(46) + 1).toUpperCase(Locale.US);
        }
        return "";
    }

    private String printHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }
}

