/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.DecisionRecordOverview;
import io.contextmap.scanner.decisionrecords.AbstractFileVisitor;
import java.nio.file.Path;

public class DecisionRecordVisitor
extends AbstractFileVisitor<DecisionRecordOverview> {
    public DecisionRecordVisitor(Path baseDir) {
        super(baseDir);
    }

    @Override
    protected boolean isExtensionToInclude(String fileExtension) {
        return "MD".equals(fileExtension) || "AD".equals(fileExtension) || "ADR".equals(fileExtension);
    }

    @Override
    protected DecisionRecordOverview convertToResult(Path file) throws Exception {
        DecisionRecordOverview adr = new DecisionRecordOverview();
        adr.filePath = file;
        adr.name = file.getFileName().toString();
        adr.contentHash = this.createContentHash(file);
        return adr;
    }
}

