/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scanner.decisionrecords;

import io.contextmap.model.FeatureFileOverview;
import io.contextmap.scanner.decisionrecords.AbstractFileVisitor;
import java.nio.file.Path;

public class FeatureFileVisitor
extends AbstractFileVisitor<FeatureFileOverview> {
    public FeatureFileVisitor(Path baseDir) {
        super(baseDir);
    }

    @Override
    protected boolean isExtensionToInclude(String fileExtension) {
        return "FEATURE".equals(fileExtension) || "STORY".equals(fileExtension);
    }

    @Override
    protected FeatureFileOverview convertToResult(Path file) throws Exception {
        FeatureFileOverview ff = new FeatureFileOverview();
        ff.filePath = file;
        ff.name = file.getFileName().toString();
        ff.contentHash = this.createContentHash(file);
        return ff;
    }

    @Override
    protected void addResult(Path file) throws Exception {
        this.results.add(this.convertToResult(file));
    }
}

