/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import cronapi.CronapiConfigurator;
import cronapi.Utils;
import cronapi.VarAdapter;
import cronapi.VarDeserializer;
import cronapi.VarSerializer;
import cronapi.Variable;
import cronapi.database.DataSource;
import cronapi.i18n.Messages;
import cronapi.json.JsonArrayWrapper;
import cronapi.json.Operations;
import cronapi.serialization.CronappModule;
import cronapi.util.GsonUTCDateAdapter;
import cronapi.util.StorageService;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.odata2.core.ep.producer.OlingoJsonSerializer;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

@com.google.gson.annotations.JsonAdapter(value=VarSerializer.class)
@XmlJavaTypeAdapter(value=VarAdapter.class)
public class Var
implements Comparable<Var>,
JsonSerializable,
OlingoJsonSerializer,
VirtualClassInterface,
Variable {
    public static final String EXP_NULL = "$null";
    public static final ScriptEngineManager factory;
    public static final ScriptEngine engine;
    public static final Pattern ISO_PATTERN;
    public static final Object[] EMPTY_OBJ_ARRAY;
    public static final Var VAR_NULL;
    public static final Var VAR_TRUE;
    public static final Var VAR_FALSE;
    public static final Var VAR_ZERO;
    public static final Var VAR_ONE;
    public static final Var VAR_NEGATIVE_ONE;
    public static final Var VAR_EMPTY;
    public static final Var VAR_DATE_ZERO;
    private static final NumberFormat _formatter;
    public static String[] ALLOWED_TYPES;
    public static Class[] MAPPED_TYPES;
    private String id;
    private Type _type;
    private Object _object;
    private boolean modifiable = true;
    private boolean created = false;

    public String serializeAsJson() {
        try {
            return new CronapiConfigurator().objectMapperBuilder().build().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(String name) {
        if (this.isNative()) {
            return this._object;
        }
        return this.getField(name).getObject();
    }

    public boolean containsKey(String name) {
        return this.getObjectAsMap().containsKey(name);
    }

    public VirtualClassInterface set(String name, Object value) {
        this.setField(name, value);
        return this;
    }

    public boolean isString() {
        return this.getType() == Type.STRING;
    }

    public boolean isNumber() {
        return this.getObject() instanceof Number;
    }

    public boolean isBoolean() {
        return this.getObject() instanceof Boolean;
    }

    public static void main(String[] args) {
        Var var = new Var("Teste");
        System.out.print(new Gson().toJson((Object)var));
    }

    public Var() {
        this._type = Type.NULL;
        this.created = true;
    }

    public Var(String id, Object object) {
        this.id = id;
        if (object instanceof Var) {
            object = ((Var)object).getObject();
        }
        this.setObject(object);
    }

    public Var(Object object) {
        this.setObject(object);
    }

    public Var(Object object, boolean modifiable) {
        this.setObject(object);
        this.modifiable = modifiable;
    }

    public Var(Var var) {
        this._type = Type.UNKNOWN;
        if (var != null) {
            this.id = var.id;
            this.setObject(var.getObject());
        }
    }

    public static Var eval(String val) {
        if (val == null || val.equalsIgnoreCase("null")) {
            return VAR_NULL;
        }
        try {
            return Var.valueOf(engine.eval(val));
        }
        catch (ScriptException scriptException) {
            return VAR_NULL;
        }
    }

    public static Var valueOf(Object val) {
        if (val instanceof Var) {
            return (Var)val;
        }
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                return VAR_TRUE;
            }
            return VAR_FALSE;
        }
        if (val == null) {
            return VAR_NULL;
        }
        if (val instanceof String && EXP_NULL.equals(val)) {
            return VAR_NULL;
        }
        return new Var(val);
    }

    public static Var valueOf(String id, Object val) {
        if (val instanceof Var && Objects.equals(((Var)val).getId(), id)) {
            return (Var)val;
        }
        return new Var(id, val);
    }

    public static String deserializeType(String value) {
        for (int i = 0; i < ALLOWED_TYPES.length; ++i) {
            if (!value.endsWith("@@" + ALLOWED_TYPES[i])) continue;
            return ALLOWED_TYPES[i];
        }
        return ALLOWED_TYPES[0];
    }

    public static Class getType(String key) {
        if (key == null) {
            return null;
        }
        for (int i = 0; i < ALLOWED_TYPES.length; ++i) {
            if (!key.endsWith("__" + ALLOWED_TYPES[i]) && !key.endsWith("@@" + ALLOWED_TYPES[i])) continue;
            return MAPPED_TYPES[i];
        }
        return null;
    }

    public static Object deserialize(String value) {
        if (value == null) {
            return null;
        }
        int type = 0;
        for (int i = 0; i < ALLOWED_TYPES.length; ++i) {
            if (!value.endsWith("@@" + ALLOWED_TYPES[i])) continue;
            type = i;
            value = value.substring(0, value.indexOf("@@"));
            break;
        }
        Var var = null;
        if (type == 0 && ISO_PATTERN.matcher(value).matches()) {
            var = Var.valueOf(Var.valueOf(value).getObjectAsDateTime());
            type = Arrays.asList(ALLOWED_TYPES).indexOf("datetime");
        } else {
            var = Var.valueOf(value);
        }
        return var.getObject(MAPPED_TYPES[type]);
    }

    public static Var newMap() {
        LinkedHashMap map = new LinkedHashMap();
        return Var.valueOf(map);
    }

    public Var put(Object key, Object value) {
        this.getObjectAsMap().put(key.toString(), Var.valueOf(value));
        return this;
    }

    public static Var newList() {
        return new Var(new LinkedList());
    }

    public static Object[] asObjectArray(Var[] vars) {
        if (vars.length > 0) {
            Object[] objs = new Object[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                objs[i] = vars[i].getObject();
            }
            return objs;
        }
        return EMPTY_OBJ_ARRAY;
    }

    public Type getType() {
        return this._type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DataSource getObjectAsDataSource() {
        return (DataSource)this._object;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object val) {
        if (this.created && !this.modifiable) {
            throw new RuntimeException(Messages.getString("NotModifiable"));
        }
        this._object = val;
        this.inferType();
        this.created = true;
    }

    public <T> T getTypedObject(Class<T> type) {
        Object object = this.getObject(type);
        if (object == null) {
            return null;
        }
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        JsonElement json = this.getObjectAsJson();
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json.toString(), type);
        }
        catch (IOException e) {
            throw new ClassCastException("Cannot cast " + object.getClass().getName() + " to " + type.getName());
        }
    }

    public Object getObject(Class type) {
        if (this._object == null) {
            return null;
        }
        if (type == Var.class || type == Variable.class) {
            return this;
        }
        if (type == String.class || type == StringBuilder.class || type == StringBuffer.class || type == Character.class) {
            return this.getObjectAsString();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return this.getObjectAsBoolean();
        }
        if (type == JsonElement.class) {
            return this.getObjectAsJson();
        }
        if (type == Timestamp.class) {
            return new Timestamp(this.getObjectAsDateTime().getTimeInMillis());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(this.getObjectAsDateTime().getTimeInMillis());
        }
        if (type == Date.class) {
            if (this.getObjectAsDateTime() instanceof Calendar) {
                return this.getObjectAsDateTime().getTime();
            }
            return this.getObjectAsDateTime();
        }
        if (type == Calendar.class) {
            return this.getObjectAsDateTime();
        }
        if (type == Long.class || type == Long.TYPE) {
            return this.getObjectAsLong();
        }
        if (type == Short.class || type == Short.TYPE) {
            return this.getObjectAsShort();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return this.getObjectAsInt();
        }
        if (type == Double.class || type == Double.TYPE) {
            return this.getObjectAsDouble();
        }
        if (type == UUID.class) {
            return UUID.fromString(this.getObjectAsString());
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(this.getObjectAsDouble().floatValue());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(this.getObjectAsDouble());
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(this.getObjectAsLong());
        }
        if (type == byte[].class) {
            return this.getObjectAsByteArray();
        }
        if (Collection.class.isAssignableFrom(type)) {
            try {
                return this.getObjectAsRawList(type);
            }
            catch (Exception e) {
                return this.getObjectAsRawList(LinkedList.class);
            }
        }
        if (Utils.isEntityClass(type) && this._object != null && DataSource.class.isAssignableFrom(this._object.getClass())) {
            return Var.valueOf(this.getObjectAsDataSource().getObject()).getObject(type);
        }
        if (Utils.isEntityClass(type) && this._object != null && !type.equals(this._object.getClass())) {
            try {
                List<String> ids = Utils.getFieldsWithAnnotationId(type);
                Object instanceClass = type.newInstance();
                if (this._object instanceof LinkedHashMap) {
                    LinkedHashMap hashmap = (LinkedHashMap)this._object;
                    for (String id : ids) {
                        Utils.updateField(instanceClass, id, hashmap.get(id));
                    }
                } else {
                    for (String id : ids) {
                        Utils.updateField(instanceClass, id, this._object);
                    }
                }
                return instanceClass;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this._object instanceof Map && type != Map.class) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SimpleModule module = new SimpleModule();
            module.addDeserializer(Var.class, (JsonDeserializer)new VarDeserializer());
            mapper.registerModule((Module)module);
            try {
                List<String> fieldsByteHeaderSignature = Utils.getFieldsWithAnnotationByteHeaderSignature(type);
                for (String fieldToGetByteContent : fieldsByteHeaderSignature) {
                    Var content = Operations.getJsonOrMapField(Var.valueOf(this._object), Var.valueOf(fieldToGetByteContent));
                    if (!StorageService.isTempFileJson(content.getObjectAsString())) continue;
                    byte[] contentByte = StorageService.getFileBytesWithMetadata(content.getObjectAsString());
                    Operations.setJsonOrMapField(Var.valueOf(this._object), Var.valueOf(fieldToGetByteContent), Var.valueOf(contentByte));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mapper.convertValue(this._object, type);
        }
        if (this._object instanceof VirtualClassInterface && type != VirtualClassInterface.class) {
            return Var.valueOf(((VirtualClassInterface)this._object).getObject()).getObject(type);
        }
        return this.getObject();
    }

    public Object cloneObject() {
        Var tempVar = new Var(this);
        return tempVar.getObject();
    }

    public Integer getObjectAsInt() {
        switch (this.getType()) {
            case STRING: {
                if (this.isEmptyOrNull().booleanValue()) {
                    return 0;
                }
                if (((String)this.getObject()).equalsIgnoreCase("null")) {
                    return 0;
                }
                try {
                    return Integer.parseInt((String)this.getObject());
                }
                catch (Exception e) {
                    return Double.valueOf(Double.parseDouble((String)this.getObject())).intValue();
                }
            }
            case INT: {
                return ((Number)this.getObject()).intValue();
            }
            case BOOLEAN: {
                return (Boolean)this.getObject() != false ? 1 : 0;
            }
            case DOUBLE: {
                return new Double((Double)this.getObject()).intValue();
            }
            case DATETIME: {
                return (int)((Calendar)this.getObject()).getTimeInMillis();
            }
            case LIST: {
                return ((List)this._object).size();
            }
        }
        if (this.getObject() instanceof Number) {
            return ((Number)this.getObject()).intValue();
        }
        return 0;
    }

    public Long getObjectAsLong() {
        switch (this.getType()) {
            case STRING: {
                if (this.isEmptyOrNull().booleanValue()) {
                    return 0L;
                }
                if (((String)this.getObject()).equalsIgnoreCase("null")) {
                    return 0L;
                }
                try {
                    return Long.parseLong((String)this.getObject());
                }
                catch (Exception e) {
                    return Double.valueOf(Double.parseDouble((String)this.getObject())).longValue();
                }
            }
            case INT: {
                return ((Number)this.getObject()).longValue();
            }
            case BOOLEAN: {
                return (Boolean)this.getObject() != false ? 1L : 0L;
            }
            case DOUBLE: {
                return new Double((Double)this.getObject()).longValue();
            }
            case DATETIME: {
                return ((Calendar)this.getObject()).getTimeInMillis();
            }
            case LIST: {
                return ((List)this._object).size();
            }
        }
        if (this.getObject() instanceof Number) {
            return ((Number)this.getObject()).longValue();
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Short getObjectAsShort() {
        if (this.getObject() instanceof Number) {
            return ((Number)this.getObject()).shortValue();
        }
        switch (this.getType()) {
            case STRING: {
                if (this.isEmptyOrNull().booleanValue()) {
                    return (short)0;
                }
                String value = ((String)this.getObject()).trim();
                if (value.equalsIgnoreCase("null")) {
                    return (short)0;
                }
                try {
                    return Double.valueOf(value).shortValue();
                }
                catch (Exception e) {
                    if (value.equalsIgnoreCase("true")) {
                        return (short)1;
                    }
                    if (!value.equalsIgnoreCase("false")) return ((Number)this.getObject()).shortValue();
                    return (short)0;
                }
            }
            case INT: {
                return ((Number)this.getObject()).shortValue();
            }
            case BOOLEAN: {
                short s;
                if (((Boolean)this.getObject()).booleanValue()) {
                    s = 1;
                    return s;
                }
                s = 0;
                return s;
            }
            case DOUBLE: {
                return ((Double)this.getObject()).shortValue();
            }
            case DATETIME: {
                return Long.valueOf(((Calendar)this.getObject()).getTimeInMillis()).shortValue();
            }
            case LIST: {
                return Integer.valueOf(((List)this._object).size()).shortValue();
            }
        }
        return (short)0;
    }

    public File getObjectAsFile() {
        if (this._object instanceof File) {
            return (File)this._object;
        }
        if (this._object instanceof Path) {
            return ((Path)this._object).toFile();
        }
        return new File(this.toString());
    }

    public JsonElement getObjectAsJsonElement() {
        if (this._object != null) {
            if (this._object instanceof JsonElement) {
                return (JsonElement)this._object;
            }
            if (this._object instanceof CharSequence) {
                return new JsonPrimitive(this.getObjectAsString());
            }
            if (this._object instanceof Boolean) {
                return new JsonPrimitive((Boolean)this._object);
            }
            if (this._object instanceof Number) {
                return new JsonPrimitive((Number)this._object);
            }
            if (this._object instanceof Character) {
                return new JsonPrimitive((Character)this._object);
            }
            return this.getObjectAsJson();
        }
        return null;
    }

    public JsonElement getObjectAsJson() {
        if (this._object != null) {
            if (this._object instanceof JsonElement) {
                return (JsonElement)this._object;
            }
            try {
                if (this._object instanceof String) {
                    return (JsonElement)new Gson().fromJson(this._object.toString(), JsonElement.class);
                }
                if (this._object instanceof InputStream) {
                    return (JsonElement)new Gson().fromJson(this.getObjectAsString(), JsonElement.class);
                }
                if (this._object.getClass().getAnnotation(Entity.class) != null) {
                    GsonBuilder builder = new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

                        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                            return fieldAttributes.getDeclaringClass() != Var.this._object.getClass() && fieldAttributes.getAnnotation(Id.class) == null;
                        }

                        public boolean shouldSkipClass(Class<?> aClass) {
                            return false;
                        }
                    });
                    builder.registerTypeAdapter(Date.class, (Object)new GsonUTCDateAdapter());
                    Gson gson = builder.create();
                    return gson.toJsonTree(this._object);
                }
                if (this.getType().equals((Object)Type.DATETIME)) {
                    return new JsonPrimitive(Utils.getISODateFormat().format(((Calendar)this.getObject()).getTime()));
                }
                ObjectMapper mapper = new ObjectMapper();
                SimpleFilterProvider filters = new SimpleFilterProvider();
                filters.setFailOnUnknownId(false);
                mapper.setFilters((FilterProvider)filters);
                String json = mapper.writeValueAsString(this._object);
                return (JsonElement)new Gson().fromJson(json, JsonElement.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Calendar getObjectAsDateTime() {
        switch (this.getType()) {
            case STRING: {
                if (((String)this.getObject()).equalsIgnoreCase("null")) {
                    return VAR_DATE_ZERO.getObjectAsDateTime();
                }
                String s = (String)this.getObject();
                return Utils.toCalendar(s, null);
            }
            case INT: {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(this.getObjectAsLong());
                return c;
            }
            case DOUBLE: {
                Calendar cd = Calendar.getInstance();
                cd.setTimeInMillis(this.getObjectAsLong());
                return cd;
            }
            case DATETIME: {
                return (Calendar)this.getObject();
            }
            case LIST: {
                break;
            }
        }
        return VAR_DATE_ZERO.getObjectAsDateTime();
    }

    private Object getPrimitiveValue(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsBigDecimal();
        }
        return element.getAsString();
    }

    public Boolean getObjectAsBoolean() {
        switch (this.getType()) {
            case STRING: {
                if (((String)this.getObject()).equalsIgnoreCase("null")) {
                    return false;
                }
                String s = (String)this.getObject();
                s = s.equals("1") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("sim") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("s") || s.equalsIgnoreCase("t") ? "true" : "false";
                return Boolean.valueOf(s);
            }
            case INT: {
                return ((Number)this.getObject()).longValue() > 0L;
            }
            case BOOLEAN: {
                return (boolean)((Boolean)this.getObject());
            }
            case DOUBLE: {
                return new Double((Double)this.getObject()).intValue() > 0;
            }
            case DATETIME: {
                break;
            }
            case LIST: {
                break;
            }
        }
        return false;
    }

    public String getMD5() {
        try {
            if (this._object instanceof File) {
                return Utils.encodeMD5((File)this._object);
            }
            if (this._object instanceof byte[]) {
                return Utils.encodeMD5((byte[])this._object);
            }
            return Utils.encodeMD5(this.getObjectAsString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Double getObjectAsDouble() {
        switch (this.getType()) {
            case STRING: {
                if (this.isEmptyOrNull().booleanValue()) {
                    return 0.0;
                }
                if (((String)this.getObject()).equalsIgnoreCase("null")) {
                    return 0.0;
                }
                return Double.parseDouble((String)this.getObject());
            }
            case INT: {
                return ((Number)this.getObject()).doubleValue();
            }
            case BOOLEAN: {
                return (Boolean)this.getObject() != false ? 1.0 : 0.0;
            }
            case DOUBLE: {
                return (double)((Double)this.getObject());
            }
            case DATETIME: {
                return ((Calendar)this.getObject()).getTimeInMillis();
            }
            case LIST: {
                return ((List)this._object).size();
            }
        }
        if (this.getObject() instanceof Number) {
            return ((Number)this.getObject()).doubleValue();
        }
        return 0.0;
    }

    /*
     * Exception decompiling
     */
    public byte[] getObjectAsByteArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getObjectAsString() {
        if (this.isNull().booleanValue()) {
            return "";
        }
        Object object = this.getObject();
        if (object == null) {
            return "";
        }
        if (object instanceof InputStream) {
            try {
                return IOUtils.toString((InputStream)((InputStream)this.getObject()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (object instanceof Document) {
            Document document = (Document)object;
            XMLOutputter outputter = new XMLOutputter();
            return outputter.outputString(document);
        }
        if (object instanceof Element) {
            Element element = (Element)object;
            XMLOutputter outputter = new XMLOutputter();
            return outputter.outputString(element);
        }
        if (object instanceof String || object instanceof File || object instanceof DataSource) {
            return object.toString();
        }
        if (this._type == Type.DATETIME) {
            return Utils.getISODateFormat().format(((Calendar)this.getObject()).getTime());
        }
        try {
            JsonElement element = this.getObjectAsJson();
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                return element.getAsString();
            }
            return element.toString();
        }
        catch (Throwable e) {
            return this._object.toString();
        }
    }

    private List getSingleList(Object o) {
        LinkedList<Var> list = new LinkedList<Var>();
        list.add(Var.valueOf(o));
        return list;
    }

    private List toList(List list) {
        LinkedList<Var> myList = new LinkedList<Var>();
        for (Object obj : list) {
            myList.add(Var.valueOf(obj));
        }
        return myList;
    }

    public Collection getObjectAsRawList(Class clazz) {
        Collection result;
        List list = this.getObjectAsList();
        try {
            result = !clazz.isInterface() ? (Collection)clazz.newInstance() : new LinkedList();
        }
        catch (Exception e) {
            result = new LinkedList();
        }
        for (Object o : list) {
            result.add(Var.valueOf(o).getObject());
        }
        return result;
    }

    public Collection getObjectAsVarList(Class clazz) {
        Collection result;
        List list = this.getObjectAsList();
        try {
            result = !clazz.isInterface() ? (Collection)clazz.newInstance() : new LinkedList();
        }
        catch (Exception e) {
            result = new LinkedList();
        }
        for (Object o : list) {
            result.add(Var.valueOf(o));
        }
        return result;
    }

    public List getObjectAsList() {
        if (this.getObject() instanceof Map) {
            LinkedList<Var> myList = new LinkedList<Var>();
            for (Object obj : ((Map)this.getObject()).values()) {
                myList.add(Var.valueOf(obj));
            }
            return myList;
        }
        if (this.getObject() instanceof JsonArray) {
            return new JsonArrayWrapper((JsonArray)this.getObject());
        }
        if (this.getObject() instanceof List) {
            return (List)this.getObject();
        }
        if (this.getObject() instanceof DataSource) {
            return this.toList(((DataSource)this.getObject()).getPage().getContent());
        }
        if (this.getObject() instanceof String) {
            String parsed = this._object.toString();
            if (this._object.toString().startsWith("[") && this._object.toString().endsWith("]")) {
                parsed = parsed.substring(1, parsed.length() - 1);
            }
            String[] values = parsed.split(",");
            LinkedList<String> list = new LinkedList<String>();
            for (String v : values) {
                if (v.trim().isEmpty()) continue;
                list.add(v.trim());
            }
            return list;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(this.getObject());
        return list;
    }

    public Map getObjectAsMap() {
        if (this.getObject() instanceof Map) {
            return (Map)this.getObject();
        }
        if (this.getObject() != null) {
            if (this.isNative()) {
                LinkedHashMap<Object, Var> map = new LinkedHashMap<Object, Var>();
                if (this.id == null) {
                    map.put(this, this);
                } else {
                    map.put(this.id, this);
                }
                return map;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new CronappModule(false));
            if (this.getObject() instanceof DataSource) {
                return (Map)mapper.convertValue(((DataSource)this.getObject()).getObject(), Map.class);
            }
            if (this.getObject() instanceof JsonObject) {
                return (Map)new Gson().fromJson(this._object.toString(), Map.class);
            }
            return (Map)mapper.convertValue(this._object, Map.class);
        }
        return new LinkedHashMap();
    }

    public Var getObjectAsPOJOList() {
        List<Var> myList = null;
        if (this.getObject() instanceof DataSource) {
            myList = new LinkedList();
            DataSource ds = (DataSource)this.getObject();
            for (Object obj : ds.getPage().getContent()) {
                myList.add(Var.valueOf(obj));
            }
        } else if (this.getObject() instanceof List) {
            myList = new LinkedList();
            for (Object obj : (List)this.getObject()) {
                myList.add(Var.valueOf(obj).getPOJO());
            }
        } else if (this.getObject() instanceof JsonArray) {
            myList = new LinkedList();
            JsonArray jsarray = (JsonArray)this.getObject();
            for (JsonElement jselement : jsarray) {
                myList.add(Var.valueOf(jselement).getPOJO());
            }
        } else {
            myList = this.getSingleList(this.getPOJO());
        }
        return Var.valueOf(myList);
    }

    public boolean isNative() {
        switch (this.getType()) {
            case STRING: 
            case INT: 
            case BOOLEAN: 
            case DOUBLE: 
            case DATETIME: {
                return true;
            }
        }
        return false;
    }

    public Var getPOJO() {
        if (this.isNative()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("value", this.getObject());
            if (this.id == null) {
                map.put("id", this.getObjectAsString());
            } else {
                map.put("id", this.id);
            }
            return Var.valueOf(map);
        }
        return this;
    }

    public Iterator<Var> iterator() {
        return this.getObjectAsList().iterator();
    }

    public Var get(int index) {
        switch (this.getType()) {
            case LIST: {
                return Var.valueOf(((List)this.getObject()).get(index));
            }
        }
        return VAR_NULL;
    }

    public int size() {
        switch (this.getType()) {
            case NULL: {
                return 0;
            }
            case LIST: {
                return ((List)this.getObject()).size();
            }
        }
        if (this.getObject() instanceof Map) {
            return ((Map)this.getObject()).size();
        }
        if (this.getObject() instanceof DataSource) {
            return ((DataSource)this.getObject()).getPage().getContent().size();
        }
        return this.getObjectAsString().length();
    }

    public int length() {
        return this.getObjectAsString().length();
    }

    public void trim() {
        this.setObject(this.getObjectAsString().trim());
    }

    public void set(int index, Var var) {
        ((List)this.getObject()).add(index, var);
    }

    public void addAll(Var var) {
        ((List)this.getObject()).addAll(var.getObjectAsList());
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode((Object)this._type);
        hash = 43 * hash + Objects.hashCode(this._object);
        return hash;
    }

    public boolean equals(Object obj) {
        return this.compareTo(Var.valueOf(obj)) == 0;
    }

    public void inc(Object value) {
        Number result = null;
        switch (this.getType()) {
            case DATETIME: {
                this.getObjectAsDateTime().add(5, Var.valueOf(value).getObjectAsInt());
                break;
            }
            case INT: {
                result = this.getObjectAsLong() + Var.valueOf(value).getObjectAsLong();
                break;
            }
            default: {
                result = this.getObjectAsDouble() + Var.valueOf(value).getObjectAsDouble();
            }
        }
        if (result != null) {
            this.setObject(result);
        }
    }

    public void multiply(Object value) {
        Number result = null;
        switch (this.getType()) {
            case INT: {
                result = this.getObjectAsLong() * Var.valueOf(value).getObjectAsLong();
                break;
            }
            default: {
                result = this.getObjectAsDouble() * Var.valueOf(value).getObjectAsDouble();
            }
        }
        if (result != null) {
            this.setObject(result);
        }
    }

    public Var append(Object value) {
        String result = this.getObjectAsString() + (value != null ? value.toString() : "");
        this.setObject(result);
        return this;
    }

    public boolean lessThan(Var var) {
        return this.compareTo(var) < 0;
    }

    public boolean lessThanOrEqual(Var var) {
        return this.compareTo(var) <= 0;
    }

    public boolean greaterThan(Var var) {
        return this.compareTo(var) > 0;
    }

    public boolean greaterThanOrEqual(Var var) {
        return this.compareTo(var) >= 0;
    }

    @Override
    public int compareTo(Var var) {
        var = Var.valueOf(var);
        try {
            if (this.getType() == Type.NULL && var.getType() == Type.NULL) {
                return 0;
            }
            if (this.getType() == Type.NULL && var.getType() != Type.NULL) {
                return -1;
            }
            if (var == this) {
                return 0;
            }
            if (this.getObject().equals(var.getObject())) {
                return 0;
            }
            switch (this.getType()) {
                case STRING: {
                    return this.getObjectAsString().compareTo(var.getObjectAsString());
                }
                case INT: {
                    if (var.getType().equals((Object)Type.INT)) {
                        return this.getObjectAsLong().compareTo(var.getObjectAsLong());
                    }
                    return this.getObjectAsDouble().compareTo(var.getObjectAsDouble());
                }
                case DOUBLE: {
                    return this.getObjectAsDouble().compareTo(var.getObjectAsDouble());
                }
                case BOOLEAN: {
                    return this.getObjectAsBoolean().compareTo(var.getObjectAsBoolean());
                }
                case DATETIME: {
                    return this.getObjectAsDateTime().compareTo(var.getObjectAsDateTime());
                }
            }
            if (this.getObject() instanceof Comparable) {
                return ((Comparable)Comparable.class.cast(this.getObject())).compareTo(var.getObject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public String toString() {
        switch (this.getType()) {
            case STRING: {
                return this.getObject().toString();
            }
            case INT: {
                Number i = (Number)this.getObject();
                return i.toString();
            }
            case DOUBLE: {
                Double d = (double)((Double)this._object);
                return _formatter.format(d);
            }
            case DATETIME: {
                return Utils.getISODateFormat().format(((Calendar)this.getObject()).getTime());
            }
            case LIST: {
                List list = (List)this.getObject();
                StringBuilder sb = new StringBuilder();
                if (list.isEmpty()) {
                    return "[]";
                }
                sb.append("[");
                for (Object v : list) {
                    sb.append(String.valueOf(v));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("]");
                return sb.toString();
            }
            case NULL: {
                return "";
            }
        }
        if (this.getObject() == null) {
            return "";
        }
        if (this.getObject() instanceof Map) {
            java.lang.reflect.Type gsonType = new TypeToken<Map<String, Object>>(){}.getType();
            return new Gson().toJson((Object)((Map)this.getObject()), gsonType);
        }
        return this.getObject().toString();
    }

    public Var negate() {
        if (this.getObjectAsBoolean().booleanValue()) {
            return VAR_FALSE;
        }
        return VAR_TRUE;
    }

    private void inferType() {
        if (this._object == null) {
            this._type = Type.NULL;
        } else if (this._object instanceof Var) {
            Var oldObj = (Var)this._object;
            this._type = oldObj.getType();
            this._object = oldObj.getObject();
            if (this.id == null) {
                this.id = oldObj.id;
            }
        } else if (this._object instanceof String || this._object instanceof StringBuilder || this._object instanceof StringBuffer || this._object instanceof Character) {
            this._type = Type.STRING;
            this._object = this._object.toString();
        } else if (this._object instanceof Boolean) {
            this._type = Type.BOOLEAN;
        } else if (this._object instanceof Date) {
            Date date = (Date)this._object;
            this._type = Type.DATETIME;
            this._object = Calendar.getInstance();
            ((Calendar)this._object).setTime(date);
        } else if (this._object instanceof Calendar) {
            this._type = Type.DATETIME;
        } else if (this._object instanceof Long) {
            this._type = Type.INT;
        } else if (this._object instanceof Short) {
            this._type = Type.INT;
        } else if (this._object instanceof Integer) {
            this._type = Type.INT;
            this._object = (long)((Integer)this._object).intValue();
        } else if (this._object instanceof Byte) {
            this._type = Type.INT;
            this._object = (long)((Byte)this._object).byteValue();
        } else if (this._object instanceof Double) {
            this._type = Type.DOUBLE;
        } else if (this._object instanceof Float) {
            this._type = Type.DOUBLE;
            this._object = (double)((Float)this._object).floatValue();
        } else if (this._object instanceof BigDecimal) {
            if (((BigDecimal)this._object).scale() == 0) {
                this._type = Type.INT;
                this._object = ((BigDecimal)this._object).longValue();
            } else {
                this._type = Type.DOUBLE;
                this._object = ((BigDecimal)this._object).doubleValue();
            }
        } else if (this._object instanceof BigInteger) {
            this._type = Type.INT;
            this._object = ((BigInteger)this._object).longValue();
        } else if (this._object instanceof LinkedList) {
            this._type = Type.LIST;
        } else if (this._object instanceof List) {
            this._type = Type.LIST;
        } else if (this._object instanceof JsonPrimitive) {
            this._object = this.getPrimitiveValue((JsonPrimitive)this._object);
            this.inferType();
        } else {
            this._type = Type.UNKNOWN;
        }
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeObject(this._object);
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        gen.writeObject(this._object);
    }

    public LinkedList<String> keySet() {
        LinkedList<String> keys = new LinkedList<String>();
        if (this.getObject() != null) {
            if (this.getObject() instanceof VirtualClassInterface && ((VirtualClassInterface)this.getObject()).getObject() instanceof Map) {
                ((Map)((VirtualClassInterface)this.getObject()).getObject()).keySet().stream().forEach(c -> keys.add(String.valueOf(c)));
            } else if (this.getObject() instanceof Map) {
                ((Map)this.getObject()).keySet().stream().forEach(c -> keys.add(String.valueOf(c)));
            } else if (this.getObject() instanceof JsonObject) {
                ((JsonObject)this.getObject()).entrySet().stream().forEach(c -> keys.add((String)c.getKey()));
            } else {
                try {
                    PropertyDescriptor[] props;
                    Class<?> clazz = this.getObject().getClass();
                    BeanInfo info = Introspector.getBeanInfo(clazz);
                    for (PropertyDescriptor pd : props = info.getPropertyDescriptors()) {
                        if (pd.getName().equals("class")) continue;
                        keys.add(pd.getName());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return keys;
    }

    public Var getField(String field) {
        try {
            return Operations.getJsonOrMapField(this, Var.valueOf(field));
        }
        catch (Exception exception) {
            return VAR_NULL;
        }
    }

    public String getStringField(String field) {
        return this.getField(field).getObjectAsString();
    }

    public void setField(String field, Object value) {
        try {
            Operations.setJsonOrMapField(this, Var.valueOf(field), Var.valueOf(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateWith(Object obj) {
        Var varObj = Var.valueOf(obj);
        for (String key : varObj.keySet()) {
            this.setField(key, varObj.getField(key));
        }
    }

    public Boolean isNull() {
        return this._object == null || this._object instanceof JsonNull;
    }

    public Boolean isEmpty() {
        if (this.getType() == Type.STRING) {
            return this.getObjectAsString().trim().isEmpty();
        }
        return this.size() == 0;
    }

    public Boolean isEmptyOrNull() {
        return this.isNull() != false || this.isEmpty() != false;
    }

    static {
        System.setProperty("https.protocols", "TLSv1.2,TLSv1.1,TLSv1,TLSv1");
        System.setProperty("org.apache.cxf.stax.allowInsecureParser", "1");
        factory = new ScriptEngineManager();
        engine = factory.getEngineByName("JavaScript");
        ISO_PATTERN = Pattern.compile("(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d\\.\\d+([+-][0-2]\\d:[0-5]\\d|Z))|(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d([+-][0-2]\\d:[0-5]\\d|Z))|(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d([+-][0-2]\\d:[0-5]\\d|Z))");
        EMPTY_OBJ_ARRAY = new Object[0];
        VAR_NULL = new Var((Object)null, false);
        VAR_TRUE = new Var(true, false);
        VAR_FALSE = new Var(false, false);
        VAR_ZERO = new Var(0, false);
        VAR_ONE = new Var(1, false);
        VAR_NEGATIVE_ONE = new Var(-1, false);
        VAR_EMPTY = new Var((Object)"", false);
        _formatter = new DecimalFormat("0.00000");
        ALLOWED_TYPES = new String[]{"text", "datetime", "date", "number", "integer", "boolean", "list"};
        MAPPED_TYPES = new Class[]{String.class, Date.class, Date.class, Double.class, Long.class, Boolean.class, Collection.class};
        Calendar calendar = Calendar.getInstance();
        calendar.set(1980, 1, 1, 0, 0, 0);
        VAR_DATE_ZERO = new Var(calendar, false);
    }

    public static enum Type {
        STRING,
        INT,
        DOUBLE,
        LIST,
        NULL,
        UNKNOWN,
        BOOLEAN,
        DATETIME;

    }

    public static class JsonAdapter {
    }
}

