/*
 * Decompiled with CFR 0.152.
 */
package cronapi.dashboard;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stimulsoft.base.licenses.StiLicense;
import com.stimulsoft.report.StiOptions;
import cronapi.CronapiConfigurator;
import cronapi.dashboard.DashboardFront;
import cronapi.report.odata.StiODataDatabase;
import cronapi.report.odata.StiODataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    private static HashMap<String, String> charCannotBeEscaped;
    private static final Logger log;
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

    DashboardService() {
    }

    public DashboardFront getDashboard(String dashboardName) {
        DashboardFront dashboardFront = new DashboardFront(dashboardName);
        return dashboardFront;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentDashboard(String dashboardName) {
        try (InputStream inputStream = this.getInputStream(dashboardName);){
            String string;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, CronapiConfigurator.ENCODING));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                JsonObject json = (JsonObject)new JsonParser().parse(content);
                json.addProperty("dashboardName", dashboardName);
                string = json.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream(String dashboardName) {
        InputStream inputStream = this.loader.getResourceAsStream(dashboardName);
        if (inputStream == null) {
            throw new RuntimeException("File [" + dashboardName + "] not found.");
        }
        return inputStream;
    }

    static {
        StiLicense.setKey((String)"6vJhGtLLLz2GNviWmUTrhSqnOItdDwjBylQzQcAOiHl4mF8Yy+Msl8Mjp+nbkDv52zYAIT+dpsXLWIrkoWUKLuRM23NSg8pIvYh6tBo4G/ZbeRpxW0S6pW7OFk7po8BkktyA+vHtfRKYFAO4H+qoK6JBlRbQjOtO9vDgdcIfkLIfhwrbQhvhyaJMnkga7SqJ2c181/qsG90YkxgF+o525F67z/Ar0uCIoz6UgebnfFX44dfr3k37tlVwgEKtHLIZhxpUddmhh10jz6LmMpOsumJtnBUxANBuvhbXwVvssIYxLAaltqYc9DvkgetJQtinc23zZp81zE9D/Sf9lXhKu6oplHsQVURDVC6gZ+keyeiHbI6DM8xf1TV2BjM3V5+C23cyQ9F3fFUM/lMPto9CZyJZTmqRnrckO/dtQ88Q2ESCQXqNOBEf0rL9jlJlWLpK/ZLwcTudISL1jW5Nd78IfXr14ejq18wnKYWsYMOq2Sd1u7cBvjt7bTXvkZpb6Lkyqlg2vKNnYcdf3kBSS94fhBFcHKQsTSq7F3njQRSsqXO1Tzu8/CBrBqx+/k7aow2DF4Vap0PFN/2/f0WGglroGh6vFk/XF0vH5fZvrDg/Edg1YzNxHuOVJJZhM3Il11eiQejV2N9V4LPh1O0Sergi1pb+IRlIzCWIA+8Zykjqn97OtF+oxVvIZdXRkIWEa00EmuJuljPCC5pKMMDqkixwRw==");
        StiOptions.Services.getDataSource().add(StiODataSource.class);
        StiOptions.Services.getDataBases().add(StiODataDatabase.class);
        charCannotBeEscaped = new HashMap<String, String>(){
            {
                this.put("/", "|slash|");
            }
        };
        log = LoggerFactory.getLogger(DashboardService.class);
    }
}

