/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.JsonElement;
import cronapi.Var;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class NativeQueryUtils {
    public static Object getObject(DBDictionary dictionary, ResultSet rs, int idx, EdmSimplePropertyImplProv property) throws SQLException {
        EdmSimpleTypeKind edmTypeKind = property.getProperty().getType();
        switch (edmTypeKind) {
            case Binary: {
                return dictionary.getBytes(rs, idx);
            }
            case Boolean: {
                return dictionary.getBoolean(rs, idx);
            }
            case Byte: {
                return dictionary.getInt(rs, idx);
            }
            case DateTime: {
                return dictionary.getCalendar(rs, idx);
            }
            case DateTimeOffset: {
                return dictionary.getCalendar(rs, idx);
            }
            case Decimal: {
                return dictionary.getDouble(rs, idx);
            }
            case Double: {
                return dictionary.getDouble(rs, idx);
            }
            case Guid: {
                return dictionary.getString(rs, idx);
            }
            case Int16: {
                return dictionary.getLong(rs, idx);
            }
            case Int32: {
                return dictionary.getLong(rs, idx);
            }
            case Int64: {
                return dictionary.getLong(rs, idx);
            }
            case SByte: {
                return dictionary.getInt(rs, idx);
            }
            case Single: {
                return dictionary.getInt(rs, idx);
            }
            case Auto: {
                return dictionary.getObject(rs, idx, Map.of());
            }
            case String: {
                return dictionary.getString(rs, idx);
            }
            case Time: {
                return dictionary.getCalendar(rs, idx);
            }
            case Null: {
                return null;
            }
        }
        return dictionary.getObject(rs, idx, Map.of());
    }

    public static void setObject(DBDictionary dictionary, PreparedStatement stmnt, int idx, Var value, EdmSimplePropertyImplProv property) throws SQLException {
        EdmSimpleTypeKind edmTypeKind = property.getProperty().getType();
        Column column = new Column();
        switch (edmTypeKind) {
            case Binary: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case Boolean: {
                dictionary.setBoolean(stmnt, idx, value.getObjectAsBoolean().booleanValue(), column);
                return;
            }
            case Byte: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case DateTime: {
                dictionary.setCalendar(stmnt, idx, value.getObjectAsDateTime(), column);
                return;
            }
            case DateTimeOffset: {
                dictionary.setCalendar(stmnt, idx, value.getObjectAsDateTime(), column);
                return;
            }
            case Decimal: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case Double: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case Guid: {
                dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
                return;
            }
            case Int16: {
                dictionary.setLong(stmnt, idx, value.getObjectAsLong().longValue(), column);
                return;
            }
            case Int32: {
                dictionary.setLong(stmnt, idx, value.getObjectAsLong().longValue(), column);
                return;
            }
            case Int64: {
                dictionary.setLong(stmnt, idx, value.getObjectAsLong().longValue(), column);
                return;
            }
            case SByte: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case Single: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case Auto: {
                dictionary.setObject(stmnt, idx, value.getObject(), 1111, column);
                return;
            }
            case String: {
                dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
                return;
            }
            case Time: {
                dictionary.setTime(stmnt, idx, new Time(value.getObjectAsDateTime().getTime().getTime()), value.getObjectAsDateTime(), column);
                return;
            }
            case Null: {
                dictionary.setNull(stmnt, idx, 1111, column);
                return;
            }
        }
        dictionary.setObject(stmnt, idx, value.getObject(), 1111, column);
    }

    public static void setObject(DBDictionary dictionary, PreparedStatement stmnt, int idx, Var value, int type, String className) throws Exception {
        Column column = new Column();
        column.setType(dictionary.getPreferredType(type));
        if (value == null || value.isNull().booleanValue()) {
            dictionary.setNull(stmnt, idx, type, column);
            return;
        }
        switch (type) {
            case -5: {
                dictionary.setLong(stmnt, idx, value.getObjectAsLong().longValue(), column);
                return;
            }
            case -2: 
            case 2009: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case -7: 
            case 16: {
                dictionary.setBoolean(stmnt, idx, value.getObjectAsBoolean().booleanValue(), column);
                return;
            }
            case 2004: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case 1: {
                if (StringUtils.isNotEmpty((CharSequence)value.getObjectAsString())) {
                    dictionary.setChar(stmnt, idx, value.getObjectAsString().charAt(0), column);
                } else {
                    dictionary.setNull(stmnt, idx, type, column);
                }
                return;
            }
            case 2005: {
                dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
                return;
            }
            case 91: {
                dictionary.setDate(stmnt, idx, value.getObjectAsDateTime().getTime(), column);
                return;
            }
            case 3: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 2001: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 8: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 6: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 4: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case 2000: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case -4: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case -1: {
                dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
                return;
            }
            case 0: {
                dictionary.setNull(stmnt, idx, type, column);
                return;
            }
            case 2: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 7: {
                dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
                return;
            }
            case 5: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case 92: {
                dictionary.setTime(stmnt, idx, new Time(value.getObjectAsDateTime().getTime().getTime()), value.getObjectAsDateTime(), column);
                return;
            }
            case 93: 
            case 2013: 
            case 2014: {
                dictionary.setTimestamp(stmnt, idx, new Timestamp(value.getObjectAsDateTime().getTime().getTime()), value.getObjectAsDateTime(), column);
                return;
            }
            case -6: {
                dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
                return;
            }
            case -3: {
                dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
                return;
            }
            case 12: {
                dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
                return;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            try {
                dictionary.setObject(stmnt, idx, value.getObject(Class.forName(className)), type, column);
            }
            catch (Throwable e) {
                dictionary.setObject(stmnt, idx, value.getObject(), type, column);
            }
        } else {
            dictionary.setObject(stmnt, idx, value.getObject(), type, column);
        }
    }

    public static void setObject(DBDictionary dictionary, PreparedStatement stmnt, int idx, Var value) throws SQLException {
        Column column = new Column();
        Object _object = value.getObject();
        if (_object == null) {
            dictionary.setNull(stmnt, idx, 1111, column);
            return;
        }
        Class<?> type = _object.getClass();
        if (type == String.class || type == StringBuilder.class || type == StringBuffer.class || type == Character.class) {
            dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            dictionary.setBoolean(stmnt, idx, value.getObjectAsBoolean().booleanValue(), column);
        } else if (type == JsonElement.class) {
            dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
        } else if (type == Timestamp.class) {
            dictionary.setTimestamp(stmnt, idx, new Timestamp(value.getObjectAsDateTime().getTime().getTime()), value.getObjectAsDateTime(), column);
        } else if (type == Date.class || type == java.util.Date.class) {
            dictionary.setDate(stmnt, idx, value.getObjectAsDateTime().getTime(), column);
        } else if (Calendar.class.isInstance(_object)) {
            dictionary.setCalendar(stmnt, idx, value.getObjectAsDateTime(), column);
        } else if (type == Long.class || type == Long.TYPE) {
            dictionary.setLong(stmnt, idx, value.getObjectAsLong().longValue(), column);
        } else if (type == Short.class || type == Short.TYPE) {
            dictionary.setShort(stmnt, idx, value.getObjectAsShort().shortValue(), column);
        } else if (type == Integer.class || type == Integer.TYPE) {
            dictionary.setInt(stmnt, idx, value.getObjectAsInt().intValue(), column);
        } else if (type == Double.class || type == Double.TYPE) {
            dictionary.setDouble(stmnt, idx, value.getObjectAsDouble().doubleValue(), column);
        } else if (type == UUID.class) {
            dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
        } else if (type == Float.class || type == Float.TYPE) {
            dictionary.setFloat(stmnt, idx, value.getObjectAsDouble().floatValue(), column);
        } else if (type == BigDecimal.class) {
            dictionary.setBigDecimal(stmnt, idx, new BigDecimal(value.getObjectAsDouble()), column);
        } else if (type == BigInteger.class) {
            dictionary.setBigInteger(stmnt, idx, BigInteger.valueOf(value.getObjectAsLong()), column);
        } else if (type == byte[].class || type == InputStream.class) {
            dictionary.setBytes(stmnt, idx, value.getObjectAsByteArray(), column);
        } else if (Collection.class.isAssignableFrom(type)) {
            dictionary.setString(stmnt, idx, value.getObjectAsString(), column);
        } else {
            dictionary.setObject(stmnt, idx, value.getObject(), 1111, column);
        }
    }
}

