'use strict';

/**
 * Translator for documentation pages.
 *
 * To enable translation you should include one of language-files in your index.html
 * after <script src='lang/translator.js' type='text/javascript'></script>.
 * For example - <script src='lang/ru.js' type='text/javascript'></script>
 *
 * If you wish to translate some new texts you should do two things:
 * 1. Add a new phrase pair ("New Phrase": "New Translation") into your language file (for example lang/ru.js). It will be great if you add it in other language files too.
 * 2. Mark that text it templates this way <anyHtmlTag data-sw-translate>New Phrase</anyHtmlTag> or <anyHtmlTag data-sw-translate value='New Phrase'/>.
 * The main thing here is attribute data-sw-translate. Only inner html, title-attribute and value-attribute are going to translate.
 *
 */
window.SwaggerTranslator = {

    _words:[],

    translate: function(sel) {
      var $this = this;
      sel = '[data-sw-translate=true]';

      $(sel).each(function() {

        if($(this).children('span').length > 0){
          $(this).children('span').each(function(){
            $(this).text($this._tryTranslate($(this).text()));
          });
        }else if($(this).attr("placeholder")){
          $(this).attr("placeholder", $this._tryTranslate($(this).attr("placeholder")));
        } else{
          if($this.asInnerText(this)){
            $(this).text($this._tryTranslate($(this).text()));
          }else{
            $(this).html($this._tryTranslate($(this).html()));
          }
        }

        if($(this).attr('title')){
          $(this).attr('title', $this._tryTranslate($(this).attr('title')));
        }
      });
    },

    _tryTranslate: function(word) {
      return this._words[$.trim(word)] !== undefined ? this._words[$.trim(word)] : word;
    },

    asInnerText: function(el){
      return $(el).is("p") || $(el).is("h3") || $(el).is("h4") || $(el).is("button");
    },
    learn: function(wordsMap) {
      this._words = wordsMap;
    }
};
