/*
 * Decompiled with CFR 0.152.
 */
package cronapi.net;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.util.Callback;
import java.net.URI;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CronapiMetaData(categoryName="Websocket", categoryTags={"Websocket"})
public class WebSocket {
    private static final Logger log = LoggerFactory.getLogger(WebSocket.class);

    @CronapiMetaData(type="function", name="{{websocketFunction}}", nameTags={"websocket"}, description="{{websocketFunctionDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var connect(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{websocketFunctionParamServer}}") Var server, final @ParamMetaData(type=CronapiMetaData.ObjectType.STATEMENTSENDER, description="{{websocketFunctionParamCallbackOpen}}") Callback onopen, final @ParamMetaData(type=CronapiMetaData.ObjectType.STATEMENTSENDER, description="{{websocketFunctionParamCallbackOnMessage}}") Callback onmessage, final @ParamMetaData(type=CronapiMetaData.ObjectType.STATEMENTSENDER, description="{{websocketFunctionParamCallbackOnError}}") Callback onError) throws Exception {
        WebSocketClient ws = new WebSocketClient(URI.create(server.getObjectAsString()), (Draft)new Draft_6455()){

            public void onOpen(ServerHandshake serverHandshake) {
                if (onopen != null) {
                    try {
                        onopen.call(Var.valueOf((Object)this));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }

            public void onMessage(String s) {
                if (onmessage != null) {
                    try {
                        onmessage.call(Var.valueOf(s));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }

            public void onClose(int i, String s, boolean b) {
                log.warn("Websocket closed: " + s);
            }

            public void onError(Exception error) {
                if (onError != null) {
                    try {
                        onError.call(Var.valueOf(error.getMessage()));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        ws.connect();
        return Var.valueOf(ws);
    }

    @CronapiMetaData(type="function", name="{{websocketFunctionSend}}", nameTags={"websocket", "send"}, description="{{websocketFunctionSendDescription}}")
    public static final void send(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{websocketFunctionSendParamWs}}") Var ws, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{websocketFunctionSendParamMessage}}") Var message) throws Exception {
        WebSocketClient client;
        if (ws.getObject() instanceof WebSocketClient && !(client = (WebSocketClient)ws.getObject()).isClosed()) {
            ((WebSocketClient)ws.getObject()).send(message.getObjectAsString());
        }
    }

    @CronapiMetaData(type="function", name="{{websocketFunctionClose}}", nameTags={"websocket", "close"}, description="{{websocketFunctionCloseDescription}}")
    public static final void close(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{websocketFunctionCloseParamWs}}") Var ws) throws Exception {
        WebSocketClient client;
        if (ws.getObject() instanceof WebSocketClient && !(client = (WebSocketClient)ws.getObject()).isClosed()) {
            ((WebSocketClient)ws.getObject()).close();
        }
    }
}

