/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import cronapi.AppConfig;
import cronapi.CronapiBeanConfigurator;
import cronapi.CronapiException;
import cronapi.RestBody;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.DataSourceFilter;
import cronapi.database.JPQLConverter;
import cronapi.i18n.Messages;
import cronapi.rest.security.CronappSecurity;
import cronapi.util.BlocklyUtil;
import cronapi.util.JsonUtil;
import cronapi.util.Operations;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ReflectionUtils;

public class QueryManager {
    public static ThreadLocal<JsonObject> JSON_CACHE = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(QueryManager.class);
    private static final Pattern DATASOURCE_PATTERN = Pattern.compile(".*\\.datasource\\.json");
    private static JsonObject JSON;
    private static JsonObject JSON_CLASSLOADER;
    private static JsonArray DEFAULT_AUTHORITIES;
    private static File fromFolder;
    public static boolean DISABLE_AUTH;
    private static Configuration freemarkerConfiguration;
    private static Pattern PATTERN_FOR_ID;
    private static BeansWrapper freemarkerBeansWrapper;

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject loadJSONFromCustomQuery() {
        if (fromFolder != null) {
            try (FileInputStream stream = new FileInputStream(fromFolder);){
                JsonObject jsonObject;
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                    jsonObject = jsonElement.getAsJsonObject();
                }
                return jsonObject;
            }
            catch (Exception e) {
                return new JsonObject();
            }
        }
        ClassLoader classLoader = QueryManager.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/customQuery.json");){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                jsonObject = jsonElement.getAsJsonObject();
            }
            return jsonObject;
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    private static String getCustomQueryId(String path, JsonObject object) {
        Matcher matcher = PATTERN_FOR_ID.matcher(path);
        return matcher.find() ? matcher.group(1) : object.get("customId").getAsString();
    }

    private static JsonElement parse(Reader reader) throws IOException {
        String data = IOUtils.toString((Reader)reader);
        for (String param : CronapiBeanConfigurator.INIT_PARAMS.keySet()) {
            data = data.replace("${" + param + "}", CronapiBeanConfigurator.INIT_PARAMS.get(param).getObjectAsString());
        }
        return new JsonParser().parse(data);
    }

    private static JsonObject loadJSON() {
        if (JSON_CLASSLOADER == null) {
            JSON_CLASSLOADER = QueryManager.extractFromClassLoader();
        }
        JsonObject result = new JsonObject();
        try {
            if (fromFolder != null) {
                if (fromFolder.isFile()) {
                    if (fromFolder.exists()) {
                        return QueryManager.loadJSONFromCustomQuery();
                    }
                    fromFolder = new File(fromFolder.getParentFile(), "datasources");
                }
                for (Map.Entry entry : JSON_CLASSLOADER.entrySet()) {
                    ((JsonObject)entry.getValue()).addProperty("plugin", Boolean.valueOf(true));
                    result.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                LinkedList files = new LinkedList();
                Files.walk(fromFolder.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> files.add(file.toFile()));
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".datasource.json")) continue;
                    try (FileInputStream stream = new FileInputStream(file2);
                         InputStreamReader reader = new InputStreamReader(stream);){
                        JsonElement jsonElement = QueryManager.parse(reader);
                        JsonObject object = jsonElement.getAsJsonObject();
                        result.add(QueryManager.getCustomQueryId(file2.getPath(), object), (JsonElement)object);
                    }
                    catch (Exception e) {
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                result = QueryManager.extractFromClassLoader();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    private static JsonObject extractFromClassLoader() {
        JsonObject result = new JsonObject();
        JsonObject queryBundle = new JsonObject();
        ClassLoader classLoader = QueryManager.class.getClassLoader();
        if (classLoader.getResourceAsStream("META-INF/customQuery.json") != null) {
            return QueryManager.loadJSONFromCustomQuery();
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResource("classpath:META-INF/datasources").exists() ? resolver.getResources("classpath:META-INF/datasources/**/*.datasource.json") : new Resource[]{};
            for (Resource resource : resources) {
                try (InputStream stream = resource.getInputStream();
                     InputStreamReader reader = new InputStreamReader(stream);){
                    JsonArray elements;
                    JsonElement jsonElement = QueryManager.parse(reader);
                    boolean isBundle = jsonElement.isJsonArray();
                    if (isBundle) {
                        elements = jsonElement.getAsJsonArray();
                    } else {
                        elements = new JsonArray();
                        elements.add((JsonElement)jsonElement.getAsJsonObject());
                    }
                    for (JsonElement element : elements) {
                        String id;
                        if (!element.isJsonObject()) continue;
                        JsonObject object = element.getAsJsonObject();
                        if (isBundle) {
                            id = object.get("customId").getAsString();
                            object.addProperty("originalId", id);
                            queryBundle.add(id, (JsonElement)object);
                            continue;
                        }
                        id = QueryManager.getCustomQueryId(resource.getURI().toString(), object);
                        object.addProperty("originalId", id);
                        result.add(id, (JsonElement)object);
                    }
                }
                catch (Exception e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            for (String queryId : queryBundle.keySet()) {
                if (result.has(queryId)) continue;
                result.add(queryId, queryBundle.get(queryId));
            }
        }
        catch (IOException e) {
            throw new CronapiException(e);
        }
        return result;
    }

    public static void loadJSONFromFile(File file) throws IOException {
        fromFolder = file;
    }

    private static JsonObject getPreparedJSON() {
        if (!CronapiBeanConfigurator.initializedParams) {
            return QueryManager.loadJSON();
        }
        if (JSON == null) {
            JSON = QueryManager.loadJSON();
        }
        return JSON;
    }

    public static JsonObject getJSON() {
        if (Operations.IS_DEBUG) {
            JsonObject json = JSON_CACHE.get();
            if (json == null) {
                json = QueryManager.loadJSON();
                JSON_CACHE.set(json);
            }
            return json;
        }
        return QueryManager.getPreparedJSON();
    }

    public static Optional<JsonObject> findQuery(String id) {
        JsonObject obj = QueryManager.getJSON().getAsJsonObject(id);
        if (obj == null) {
            for (Map.Entry entry : QueryManager.getJSON().entrySet()) {
                JsonObject customObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (QueryManager.isNull(customObj.get("customId")) || !customObj.get("customId").getAsString().equalsIgnoreCase(id)) continue;
                obj = customObj;
                break;
            }
        }
        return Optional.ofNullable(obj);
    }

    public static JsonObject getQuery(String id) {
        Optional<JsonObject> obj = QueryManager.findQuery(id);
        if (obj.isEmpty()) {
            throw new RuntimeException(Messages.getString("queryNotFound"));
        }
        JsonObject query = obj.get();
        RestClient.getRestClient().setQuery(query);
        return query;
    }

    public static String getJPQL(JsonObject query, boolean checkMultitenant) {
        if (!QueryManager.isNull(query.get("query"))) {
            if (query.get("query").isJsonObject()) {
                JsonObject queryObj = query.get("query").getAsJsonObject();
                if (queryObj.get("isRawSql") != null && !queryObj.get("isRawSql").isJsonNull() && queryObj.get("isRawSql").getAsBoolean()) {
                    return queryObj.get("sqlContent").getAsString();
                }
                return JPQLConverter.sqlFromJson(queryObj, checkMultitenant);
            }
            return query.get("query").getAsString();
        }
        return null;
    }

    public static String getType(JsonObject obj) {
        if (obj.get("sourceType") != null && !obj.get("sourceType").isJsonNull()) {
            return obj.get("sourceType").getAsString();
        }
        return "entityFullName";
    }

    public static void checkSecurity(JsonObject obj, String verb) {
        QueryManager.checkSecurity(obj, verb, true);
    }

    public static JsonArray getAuthorities(JsonObject datasource, String verb) {
        JsonArray authorities;
        try {
            authorities = datasource.getAsJsonObject("verbs").get(verb + "Authorities").getAsJsonArray();
            if (QueryManager.isNull((JsonElement)authorities) || authorities.getAsJsonArray().size() == 0) {
                authorities = DEFAULT_AUTHORITIES;
            }
        }
        catch (Exception e) {
            authorities = DEFAULT_AUTHORITIES;
        }
        return authorities;
    }

    public static void checkSecurity(JsonObject obj, String verb, boolean checkAuthorities) {
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        if (!obj.getAsJsonObject("verbs").get(verb).getAsBoolean()) {
            throw new RuntimeException(Messages.format(Messages.getString("verbNotAllowed"), verb));
        }
        if (checkAuthorities) {
            boolean authorized = false;
            JsonArray authorities = QueryManager.getAuthorities(obj, verb);
            for (JsonElement a : authorities) {
                String role = a.getAsString();
                if (role.equalsIgnoreCase("authenticated")) {
                    boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                    if (authorized) break;
                }
                if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                    authorized = true;
                    break;
                }
                for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                    if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                    authorized = true;
                    break;
                }
                if (!authorized) continue;
                break;
            }
            if (!authorized) {
                throw new RuntimeException(Messages.getString("notAllowed"));
            }
        }
    }

    public static boolean isNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    public static void addDefaultValues(JsonObject query, Var ds, boolean onlyNull) {
        if (!QueryManager.isNull(query.get("defaultValues"))) {
            for (Map.Entry entry : query.get("defaultValues").getAsJsonObject().entrySet()) {
                Var value;
                if (((JsonElement)entry.getValue()).isJsonNull()) continue;
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    JsonObject event = ((JsonElement)entry.getValue()).getAsJsonObject();
                    Var name = Var.valueOf(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString());
                    try {
                        value = Operations.callBlockly(name, Var.valueOf(ds));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    value = QueryManager.parseExpressionValue((JsonElement)entry.getValue());
                }
                if (onlyNull) {
                    if (ds.getField((String)entry.getKey()) != null) continue;
                    ds.setField((String)entry.getKey(), value);
                    continue;
                }
                ds.setField((String)entry.getKey(), value);
            }
        }
    }

    public static Var executeEvent(JsonObject query, Object ds, String eventName) {
        return QueryManager.executeEvent(query, ds, eventName, null, null, null);
    }

    public static Var executeEvent(JsonObject query, Object ds, String eventName, List<Object> keys, String entityName, Map<String, Var> customValues) {
        JsonObject events = query.getAsJsonObject("events");
        if (!QueryManager.isNull((JsonElement)events) && !QueryManager.isNull(events.get(eventName))) {
            JsonObject event = events.getAsJsonObject(eventName);
            Var name = Var.valueOf(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString());
            try {
                return QueryManager.callBlocly(event, name, ds, keys, entityName, eventName, customValues);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Var callBlocly(JsonObject event, Var methodName, Object ds, List<Object> keys, String entityName, String eventName, Map<String, Var> extraValues) {
        try {
            if (event.get("blocklyParams") != null) {
                JsonArray bloclyParams = event.get("blocklyParams").getAsJsonArray();
                Var[] params = new Var[bloclyParams.size()];
                for (int i = 0; i < bloclyParams.size(); ++i) {
                    JsonObject param = bloclyParams.get(i).getAsJsonObject();
                    LinkedHashMap<String, Var> customValues = new LinkedHashMap<String, Var>();
                    customValues.put("data", Var.valueOf(ds));
                    if (keys != null && keys.size() > 0) {
                        customValues.put("primaryKeys", Var.valueOf(keys));
                        customValues.put("primaryKey", Var.valueOf(keys.get(0)));
                    }
                    customValues.put("entityName", Var.valueOf(entityName));
                    customValues.put("eventName", Var.valueOf(eventName));
                    if (extraValues != null) {
                        customValues.putAll(extraValues);
                    }
                    String id = null;
                    if (!QueryManager.isNull(param.get("id"))) {
                        id = param.get("id").getAsString();
                    }
                    params[i] = QueryManager.parseExpressionValue(id, null, ds, param.get("value"), customValues);
                }
                return Operations.callBlockly(methodName, params);
            }
            return Operations.callBlockly(methodName, Var.VAR_NULL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void executeEvent(JsonObject query, String eventName, Map<String, Var> customValues) {
        JsonObject events = query.getAsJsonObject("events");
        if (!QueryManager.isNull((JsonElement)events) && !QueryManager.isNull(events.get(eventName))) {
            JsonObject event = events.getAsJsonObject(eventName);
            Var name = Var.valueOf(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString());
            Var[] params = new Var[]{};
            if (event.get("blocklyParams") != null) {
                JsonArray bloclyParams = event.get("blocklyParams").getAsJsonArray();
                params = new Var[bloclyParams.size()];
                for (int i = 0; i < bloclyParams.size(); ++i) {
                    JsonObject param = bloclyParams.get(i).getAsJsonObject();
                    customValues.put("eventName", Var.valueOf(eventName));
                    String id = null;
                    if (!QueryManager.isNull(param.get("id"))) {
                        id = param.get("id").getAsString();
                    }
                    params[i] = QueryManager.parseExpressionValue(id, query, null, param.get("value"), customValues);
                }
            }
            try {
                Operations.callBlockly(name, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void executeEvent(JsonObject query, String eventName, Var ... params) {
        JsonObject events = query.getAsJsonObject("events");
        if (!QueryManager.isNull((JsonElement)events) && !QueryManager.isNull(events.get(eventName))) {
            JsonObject event = events.getAsJsonObject(eventName);
            Var name = Var.valueOf(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString());
            try {
                Operations.callBlockly(name, params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void executeNavigateEvent(JsonObject query, DataSource ds) {
        JsonObject events = query.getAsJsonObject("events");
        if (!QueryManager.isNull((JsonElement)events) && !QueryManager.isNull(events.get("onNavigate"))) {
            JsonObject event = events.getAsJsonObject("onNavigate");
            Var name = Var.valueOf(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString());
            Var dsVar = Var.valueOf(ds);
            int current = ds.getCurrent();
            int size = ds.getPage().getContent().size();
            for (int i = 0; i < size; ++i) {
                try {
                    Operations.callBlockly(name, dsVar);
                    ds.nextOnPage();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ds.setCurrent(current);
        }
    }

    public static Var doExecuteBlockly(JsonObject blockly, String method, Var ... params) throws Exception {
        String function = blockly.get("blocklyMethod").getAsString();
        if (method != null && !QueryManager.isNull(blockly.get("blockly" + method.toUpperCase() + "Method"))) {
            function = blockly.get("blockly" + method.toUpperCase() + "Method").getAsString();
        }
        Var name = Var.valueOf(blockly.get("blocklyClass").getAsString() + ":" + function);
        return Operations.callBlockly(name, params);
    }

    public static Var executeBlockly(JsonObject query, String method, Var ... vars) {
        if (!QueryManager.isNull((JsonElement)query.getAsJsonObject("blockly"))) {
            try {
                return QueryManager.doExecuteBlockly(query.getAsJsonObject("blockly"), method, vars);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Var.VAR_NULL;
    }

    public static boolean hasParameterValue(JsonObject customQuery, String param) {
        JsonArray paramValues = customQuery.getAsJsonArray("queryParamsValues");
        if (paramValues != null) {
            for (int x = 0; x < paramValues.size(); ++x) {
                JsonElement prv = paramValues.get(x);
                if (!param.equals(prv.getAsJsonObject().get("fieldName").getAsString())) continue;
                JsonElement fieldValue = prv.getAsJsonObject().get("fieldValue");
                boolean exist = false;
                if (fieldValue != null && !fieldValue.isJsonNull()) {
                    exist = fieldValue.isJsonPrimitive() ? !fieldValue.getAsJsonPrimitive().getAsString().isBlank() : !fieldValue.toString().isBlank();
                }
                return exist;
            }
        }
        return false;
    }

    public static Var getParameterValue(JsonObject customQuery, String param, Object ds, Map<String, Var> customValues) {
        JsonArray paramValues = customQuery.getAsJsonArray("queryParamsValues");
        if (paramValues != null) {
            for (int x = 0; x < paramValues.size(); ++x) {
                JsonElement prv = paramValues.get(x);
                if (!param.equals(prv.getAsJsonObject().get("fieldName").getAsString())) continue;
                if (JsonUtil.isNullOrBlank(prv.getAsJsonObject().get("fieldValue"))) {
                    String strValue = RestClient.getRestClient().getParameter(param);
                    if (!StringUtils.isBlank((CharSequence)strValue)) {
                        return Var.valueOf(strValue);
                    }
                    return Var.VAR_NULL;
                }
                return QueryManager.parseExpressionValue(ds, ((JsonObject)prv).get("fieldValue"), customValues);
            }
        }
        return Var.VAR_NULL;
    }

    public static Var getParameterValue(JsonObject customQuery, String param, Map<String, Var> customValues) {
        JsonArray paramValues = customQuery.getAsJsonArray("queryParamsValues");
        if (paramValues != null) {
            for (int x = 0; x < paramValues.size(); ++x) {
                JsonElement prv = paramValues.get(x);
                if (!param.equals(prv.getAsJsonObject().get("fieldName").getAsString())) continue;
                if (JsonUtil.isNullOrBlank(prv.getAsJsonObject().get("fieldValue"))) {
                    return Var.VAR_NULL;
                }
                return QueryManager.parseExpressionValue(null, customQuery, null, ((JsonObject)prv).get("fieldValue"), customValues);
            }
        }
        return Var.VAR_NULL;
    }

    public static String getBlocklyMethod(JsonObject query, String method) {
        JsonObject blockly = query.getAsJsonObject("blockly");
        String function = blockly.get("blocklyMethod").getAsString();
        if (method != null && !QueryManager.isNull(blockly.get("blockly" + method.toUpperCase() + "Method"))) {
            function = blockly.get("blockly" + method.toUpperCase() + "Method").getAsString();
        }
        return function;
    }

    private static void addIgnoreField(String field) {
        HashSet<String> ignores = (HashSet<String>)RestClient.getRestClient().getRequest().getAttribute("BeanPropertyFilter");
        if (ignores == null) {
            ignores = new HashSet<String>();
            RestClient.getRestClient().getRequest().setAttribute("BeanPropertyFilter", ignores);
        }
        ignores.add(field);
    }

    public static boolean isFieldAuthorized(Class clazzToCheck, String key, String method) throws Exception {
        CronappSecurity security;
        Field field;
        Class clazz;
        if (DISABLE_AUTH) {
            return true;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return true;
        }
        RestClient client = RestClient.getRestClient();
        if (client.getRequest() != null && clazzToCheck != null && (clazz = clazzToCheck) != null && (field = ReflectionUtils.findField((Class)clazz, (String)key)) != null && (security = field.getAnnotation(CronappSecurity.class)) instanceof CronappSecurity) {
            CronappSecurity cronappSecurity = security;
            try {
                String value;
                Method methodPermission = cronappSecurity.getClass().getMethod(method == null ? client.getMethod().toLowerCase() : method.toLowerCase(), new Class[0]);
                if (methodPermission != null && (value = (String)methodPermission.invoke((Object)cronappSecurity, new Object[0])) != null && !value.isEmpty()) {
                    String[] authorities;
                    boolean authorized = false;
                    for (String role : authorities = value.trim().split(";")) {
                        if (role.equalsIgnoreCase("authenticated")) {
                            boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                            if (authorized) break;
                        }
                        if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                            authorized = true;
                            break;
                        }
                        for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                            if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                            authorized = true;
                            break;
                        }
                        if (authorized) break;
                    }
                    if (!authorized) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static void checkSecurity(Class clazz, String method) throws Exception {
        CronappSecurity cronappSecurity;
        Method methodPermission;
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        if (!AppConfig.exposeLocalEntities()) {
            throw new RuntimeException(Messages.getString("notAllowed"));
        }
        CronappSecurity security = clazz.getAnnotation(CronappSecurity.class);
        boolean authorized = false;
        if (security instanceof CronappSecurity && (methodPermission = (cronappSecurity = security).getClass().getMethod(method.toLowerCase(), new Class[0])) != null) {
            String[] authorities;
            String value = (String)methodPermission.invoke((Object)cronappSecurity, new Object[0]);
            if (value == null || value.trim().isEmpty()) {
                value = "authenticated";
            }
            for (String role : authorities = value.trim().split(";")) {
                if (role.equalsIgnoreCase("authenticated")) {
                    boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                    if (authorized) break;
                }
                if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                    authorized = true;
                    break;
                }
                for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                    if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                    authorized = true;
                    break;
                }
                if (authorized) break;
            }
        }
        if (!authorized) {
            throw new RuntimeException(Messages.getString("notAllowed"));
        }
    }

    public static JsonObject createDefaultPermission(JsonElement permission, String method) {
        JsonObject permissionAsObject;
        String methodLowerCase = method.toLowerCase();
        JsonObject jsonObject = permissionAsObject = QueryManager.isNull(permission) ? new JsonObject() : permission.getAsJsonObject();
        if (QueryManager.isNull(permissionAsObject.get(methodLowerCase))) {
            permissionAsObject.addProperty(methodLowerCase, "authenticated");
        }
        return permissionAsObject;
    }

    public static boolean isDynamicField(JsonObject query, String field) {
        JsonElement dfv = query.get("defaultValuesProperties");
        if (!QueryManager.isNull(dfv) && dfv.isJsonObject()) {
            JsonObject defaultValuesProperties = dfv.getAsJsonObject();
            return !defaultValuesProperties.has(field);
        }
        return true;
    }

    public static boolean isFieldAuthorized(JsonObject query, String field, String method) throws Exception {
        if (DISABLE_AUTH) {
            return true;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return true;
        }
        if (QueryManager.isDynamicField(query, field)) {
            try {
                QueryManager.checkSecurity(query, method, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!QueryManager.isNull(query.get("security"))) {
            JsonObject permission;
            JsonObject security = query.get("security").getAsJsonObject();
            JsonElement fieldSecurity = security.get(field);
            if (fieldSecurity == null || fieldSecurity.isJsonNull()) {
                fieldSecurity = new JsonObject();
                ArrayList authorityList = new ArrayList();
                JsonArray authorities = QueryManager.getAuthorities(query, method);
                authorities.forEach(item -> authorityList.add(item.getAsString()));
                fieldSecurity.getAsJsonObject().addProperty(method.toLowerCase(), String.join((CharSequence)";", authorityList));
            }
            if (!QueryManager.isNull((permission = QueryManager.createDefaultPermission(fieldSecurity, method)).get(method.toLowerCase()))) {
                Object[] roles = permission.get(method.toLowerCase()).getAsString().toLowerCase().split(";");
                boolean authorized = false;
                if (ArrayUtils.contains((Object[])roles, (Object)"authenticated")) {
                    boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                }
                if (ArrayUtils.contains((Object[])roles, (Object)"public") || ArrayUtils.contains((Object[])roles, (Object)"permitAll")) {
                    authorized = true;
                }
                if (!authorized) {
                    for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                        if (!ArrayUtils.contains((Object[])roles, (Object)authority.getAuthority().toLowerCase())) continue;
                        authorized = true;
                        break;
                    }
                }
                return authorized;
            }
        }
        return true;
    }

    public static void checkFieldSecurity(JsonObject query, Object ds, String method) throws Exception {
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        if (!QueryManager.isNull(query.get("security"))) {
            JsonObject security = query.get("security").getAsJsonObject();
            for (Map.Entry entry : security.entrySet()) {
                JsonObject permission;
                if (QueryManager.isNull((JsonElement)entry.getValue()) || QueryManager.isNull((permission = ((JsonElement)entry.getValue()).getAsJsonObject()).get(method.toLowerCase()))) continue;
                Object[] roles = permission.get(method.toLowerCase()).getAsString().toLowerCase().split(";");
                boolean authorized = false;
                if (ArrayUtils.contains((Object[])roles, (Object)"public") || ArrayUtils.contains((Object[])roles, (Object)"permitAll")) {
                    authorized = true;
                }
                if (ArrayUtils.contains((Object[])roles, (Object)"authenticated")) {
                    boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                }
                if (!authorized) {
                    for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                        if (!ArrayUtils.contains((Object[])roles, (Object)authority.getAuthority().toLowerCase())) continue;
                        authorized = true;
                        break;
                    }
                }
                if (!authorized && ds instanceof UriInfo) {
                    UriInfo uriView = (UriInfo)ds;
                    EdmEntityType entityType = uriView.getTargetEntitySet().getEntityType();
                    if (uriView.getSelect().isEmpty()) {
                        for (String propertyName : entityType.getPropertyNames()) {
                            EdmProperty edmProperty = (EdmProperty)entityType.getProperty(propertyName);
                        }
                    }
                }
                if (!authorized && method.equalsIgnoreCase("GET")) {
                    QueryManager.addIgnoreField(((DataSource)ds).getDomainClass().getName() + "#" + (String)entry.getKey());
                }
                if (authorized || method.equalsIgnoreCase("GET")) continue;
                if (ds instanceof Var) {
                    ((Var)ds).getObjectAsMap().remove(entry.getKey());
                    continue;
                }
                if (!(ds instanceof RestBody)) continue;
                ((RestBody)ds).getInputs()[0].getObjectAsMap().remove(entry.getKey());
            }
        }
    }

    public static void checkFilterSecurity(JsonObject query, DataSourceFilter filter) {
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        if (!QueryManager.isNull(query.get("security")) && filter != null && filter.getItems().size() > 0) {
            JsonObject security = query.get("security").getAsJsonObject();
            for (DataSourceFilter.DataSourceFilterItem item : filter.getItems()) {
                JsonObject permission;
                if (QueryManager.isNull(security.get(item.key)) || QueryManager.isNull((permission = security.get(item.key).getAsJsonObject()).get("filter"))) continue;
                String[] roles = permission.get("filter").getAsString().toLowerCase().split(";");
                boolean authorized = false;
                for (String role : roles) {
                    if (role.equalsIgnoreCase("public") || role.equalsIgnoreCase("permitAll")) {
                        authorized = true;
                        break;
                    }
                    if (role.equalsIgnoreCase("authenticated")) {
                        boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                        if (authorized) break;
                    }
                    if (!authorized) {
                        for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                            if (!authority.getAuthority().equalsIgnoreCase(role)) continue;
                            authorized = true;
                            break;
                        }
                    }
                    if (authorized) break;
                }
                if (authorized) continue;
                throw new RuntimeException(Messages.getString("notAllowed"));
            }
        }
    }

    public static void checkEntityFilterSecurity(Object obj, List<String> filters) {
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        for (String filter : filters) {
            CronappSecurity security;
            String authoritiesStr;
            Field f = null;
            try {
                f = clazz.getDeclaredField(filter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f == null) continue;
            CronappSecurity annotation = f.getAnnotation(CronappSecurity.class);
            boolean authorized = true;
            if (annotation != null && (authoritiesStr = (security = annotation).filter()) != null && !authoritiesStr.trim().isEmpty()) {
                String[] authorities;
                authorized = false;
                block3: for (String role : authorities = authoritiesStr.trim().split(";")) {
                    if (role.equalsIgnoreCase("authenticated")) {
                        boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                        if (authorized) break;
                    }
                    if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                        authorized = true;
                        break;
                    }
                    for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                        if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                        authorized = true;
                        continue block3;
                    }
                }
            }
            if (authorized) continue;
            throw new RuntimeException(Messages.getString("notAllowed"));
        }
    }

    public static void checkFilterSecurity(JsonObject query, List<String> filter) {
        if (DISABLE_AUTH) {
            return;
        }
        if (!AppConfig.hasAnyTypeAuthentication()) {
            return;
        }
        if (!QueryManager.isNull(query.get("security")) && filter != null && filter.size() > 0) {
            JsonObject security = query.get("security").getAsJsonObject();
            for (String item : filter) {
                JsonObject permission;
                if (QueryManager.isNull(security.get(item)) || QueryManager.isNull((permission = security.get(item).getAsJsonObject()).get("filter"))) continue;
                String[] roles = permission.get("filter").getAsString().toLowerCase().split(";");
                boolean authorized = false;
                for (String role : roles) {
                    if (role.equalsIgnoreCase("public") || role.equalsIgnoreCase("permitAll")) {
                        authorized = true;
                        break;
                    }
                    if (role.equalsIgnoreCase("authenticated")) {
                        boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                        if (authorized) break;
                    }
                    if (!authorized) {
                        for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                            if (!authority.getAuthority().equalsIgnoreCase(role)) continue;
                            authorized = true;
                            break;
                        }
                    }
                    if (authorized) break;
                }
                if (authorized) continue;
                throw new RuntimeException(Messages.getString("notAllowed"));
            }
        }
    }

    public static Map<String, Object> getCalcFieldValues(JsonObject query, Object bean) {
        return QueryManager.getFieldValues("calcFields", query, bean);
    }

    public static Map<String, Object> getDefaultValues(JsonObject query, Object bean) {
        return QueryManager.getFieldValues("defaultValues", query, bean);
    }

    private static Map<String, Object> getFieldValues(String prefix, JsonObject query, Object bean) {
        JsonObject calcObj = null;
        HashMap<String, Object> result = null;
        if (!QueryManager.isNull(query.get(prefix))) {
            calcObj = query.get(prefix).getAsJsonObject();
        }
        if (calcObj != null) {
            JsonObject securityObj = null;
            if (!QueryManager.isNull(query.get(prefix + "Security"))) {
                securityObj = query.get(prefix + "Security").getAsJsonObject();
            }
            for (Map.Entry entry : calcObj.entrySet()) {
                JsonElement element;
                String name = (String)entry.getKey();
                boolean authorized = true;
                if (securityObj != null && !QueryManager.isNull(securityObj.get(name)) && !QueryManager.isNull(securityObj.get(name).getAsJsonObject().get("get"))) {
                    String security = securityObj.get(name).getAsJsonObject().get("get").getAsString();
                    if (security == null) {
                        security = "public";
                    }
                    String[] roles = security.split(";");
                    authorized = false;
                    for (String role : roles) {
                        if (role.equalsIgnoreCase("public") || role.equalsIgnoreCase("permitAll")) {
                            authorized = true;
                            break;
                        }
                        if (role.equalsIgnoreCase("authenticated")) {
                            boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                            if (authorized) break;
                        }
                        if (!authorized) {
                            for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                                if (!authority.getAuthority().equalsIgnoreCase(role)) continue;
                                authorized = true;
                                break;
                            }
                        }
                        if (authorized) break;
                    }
                }
                if (!authorized || QueryManager.isNull(element = calcObj.get(name))) continue;
                Var value = Var.VAR_NULL;
                if (element.isJsonPrimitive()) {
                    if (bean instanceof HashMap) {
                        value = Var.valueOf(((HashMap)bean).get(name));
                    }
                    if (value.isEmptyOrNull().booleanValue()) {
                        value = QueryManager.parseExpressionValue(null, query, bean, element, null);
                    }
                } else {
                    try {
                        JsonObject object = element.getAsJsonObject();
                        String method = object.get("blocklyMethod").getAsString();
                        Var call = Var.valueOf(object.get("blocklyClass").getAsString() + ":" + method);
                        value = QueryManager.callBlocly(object, call, bean, null, null, null, null);
                    }
                    catch (Exception e) {
                        value = Var.valueOf("ERROR: " + e.getMessage());
                    }
                }
                if (result == null) {
                    result = new HashMap<String, Object>();
                }
                result.put(name, value.getObject());
            }
        }
        return result;
    }

    public static Var parseExpressionValue(Object ds, String str, Map<String, Var> customValues) {
        return QueryManager.parseExpressionValue(null, ds, str, customValues);
    }

    public static Var parseExpressionValue(JsonObject query, Object ds, String str, Map<String, Var> customValues) {
        Object element = str == "null" ? JsonNull.INSTANCE : (NumberUtils.isNumber((String)str) ? new JsonPrimitive((Number)Double.parseDouble(str)) : (str.equals("true") || str.equals("false") ? new JsonPrimitive(Boolean.valueOf(str)) : new JsonPrimitive(str)));
        return QueryManager.parseExpressionValue(null, query, ds, (JsonElement)element, customValues);
    }

    public static Var parseExpressionValue(Object ds, JsonElement element, Map<String, Var> customValues) {
        return QueryManager.parseExpressionValue(null, null, ds, element, customValues);
    }

    public static Var parseExpressionValue(String id, JsonObject query, Object ds, JsonElement element, Map<String, Var> customValues) {
        Var value = Var.VAR_NULL;
        if (!QueryManager.isNull(element)) {
            JsonObject blockly;
            if (element.isJsonPrimitive()) {
                if (element.getAsJsonPrimitive().isBoolean()) {
                    value = Var.valueOf(element.getAsJsonPrimitive().getAsBoolean());
                } else if (element.getAsJsonPrimitive().isNumber()) {
                    value = Var.valueOf(element.getAsJsonPrimitive().getAsNumber());
                } else if (!element.getAsJsonPrimitive().getAsString().isEmpty()) {
                    if (customValues != null && customValues.containsKey(element.getAsJsonPrimitive().getAsString())) {
                        return customValues.get(element.getAsJsonPrimitive().getAsString());
                    }
                    if (ds != null && element.getAsJsonPrimitive().getAsString().startsWith("data.")) {
                        String key = element.getAsJsonPrimitive().getAsString().substring(5);
                        return Var.valueOf(ds).getField(key);
                    }
                    if (ds != null && element.getAsJsonPrimitive().getAsString().equals("data")) {
                        return Var.valueOf(ds);
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("token")) {
                        return Var.valueOf(RestClient.getRestClient().getToken());
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("username") && RestClient.getRestClient().getUser() != null) {
                        return Var.valueOf(RestClient.getRestClient().getUser().getUsername());
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("now")) {
                        return Var.valueOf(Calendar.getInstance());
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("guid")) {
                        return Var.valueOf(UUID.randomUUID().toString());
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("roles")) {
                        return Var.valueOf(RestClient.getRestClient().getUser().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()));
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("applicationId")) {
                        return Var.valueOf(AppConfig.getApplicationId());
                    }
                    if (element.getAsJsonPrimitive().getAsString().startsWith("token.")) {
                        String key = element.getAsJsonPrimitive().getAsString().substring(6);
                        return cronapi.screen.Operations.getTokenClaim(Var.valueOf(key));
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("SSOAccessToken")) {
                        return cronapi.screen.Operations.getTokenClaim(Var.valueOf("SSOAccessToken"));
                    }
                    if (element.getAsJsonPrimitive().getAsString().equals("SSOUserDetails")) {
                        return cronapi.screen.Operations.getTokenClaim(Var.valueOf("SSOUserDetails"));
                    }
                    if (element.getAsJsonPrimitive().getAsString().startsWith("session.")) {
                        String key = element.getAsJsonPrimitive().getAsString().substring(8);
                        return Operations.getValueFromSession(Var.valueOf(key));
                    }
                    if (query != null && element.getAsJsonPrimitive().getAsString().startsWith(":")) {
                        String key = element.getAsJsonPrimitive().getAsString().substring(1);
                        return QueryManager.getParameterValue(query, key, ds, customValues);
                    }
                    if (element.getAsJsonPrimitive().getAsString().startsWith("cronapi.server")) {
                        return BlocklyUtil.execute(element.getAsJsonPrimitive().getAsString(), ds, customValues);
                    }
                    if (element.getAsJsonPrimitive().getAsString().startsWith("expression:")) {
                        String template = StringUtils.removeStart((String)element.getAsJsonPrimitive().getAsString(), (String)"expression:");
                        value = QueryManager.processTemplate(template, Var.valueOf(ds).getObjectAsMap(), customValues);
                    } else {
                        value = customValues != null && customValues.containsKey(element.getAsJsonPrimitive().getAsString()) ? customValues.get(element.getAsJsonPrimitive().getAsString()) : Var.eval(element.getAsJsonPrimitive().getAsString());
                    }
                }
            } else if (element.isJsonObject() && "java".equals((blockly = element.getAsJsonObject()).get("blocklyLanguage").getAsString())) {
                JsonObject jsonCallBlockly = new JsonObject();
                jsonCallBlockly.add("blockly", (JsonElement)blockly);
                String method = blockly.get("blocklyMethod").getAsString();
                Var[] blocklyParams = new Var[]{};
                if (!QueryManager.isNull(blockly.get("blocklyParams"))) {
                    JsonArray params = blockly.getAsJsonArray("blocklyParams");
                    blocklyParams = new Var[params.size()];
                    for (int countBlocklys = 0; countBlocklys < params.size(); ++countBlocklys) {
                        JsonObject valueObj = params.get(countBlocklys).getAsJsonObject();
                        blocklyParams[countBlocklys] = QueryManager.parseExpressionValue(null, null, null, valueObj.get("value"), customValues);
                    }
                }
                value = QueryManager.executeBlockly(jsonCallBlockly, method, blocklyParams);
            }
        }
        return id != null ? Var.valueOf(id, value) : value;
    }

    private static Var processTemplate(String templateStr, Object data, Map<String, Var> customValues) {
        HashMap<String, String> applicationData = new HashMap<String, String>();
        applicationData.put("id", AppConfig.guid());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        if (customValues != null) {
            for (Map.Entry<String, Var> entry : customValues.entrySet()) {
                dataModel.put(entry.getKey(), entry.getValue().getObject());
            }
        }
        dataModel.put("application", applicationData);
        dataModel.put("data", data);
        dataModel.put("statics", freemarkerBeansWrapper.getStaticModels());
        try {
            Template template = new Template("expression", (Reader)new StringReader(templateStr), freemarkerConfiguration);
            StringWriter writer = new StringWriter();
            template.process(dataModel, (Writer)writer);
            return Var.valueOf(((Object)writer).toString());
        }
        catch (TemplateException | IOException e) {
            throw new CronapiException("Error processing template: " + templateStr);
        }
    }

    public static Var parseExpressionValue(JsonElement element) {
        return QueryManager.parseExpressionValue(null, null, null, element, null);
    }

    public static void addCalcFields(JsonObject query, DataSource ds) {
        QueryManager.addCalcFields(query, ds, true);
    }

    public static void addCalcFields(JsonObject query, Object ds, boolean post) {
        if (!QueryManager.isNull(query.get("calcFields")) && RestClient.getRestClient() != null && RestClient.getRestClient().getRequest() != null) {
            for (Map.Entry entry : query.get("calcFields").getAsJsonObject().entrySet()) {
                JsonObject obj;
                LinkedHashMap<CallSite, JsonElement> newProperties = (LinkedHashMap<CallSite, JsonElement>)RestClient.getRestClient().getRequest().getAttribute("NewBeanProperty");
                if (newProperties == null) {
                    newProperties = new LinkedHashMap<CallSite, JsonElement>();
                    RestClient.getRestClient().getRequest().setAttribute("NewBeanProperty", newProperties);
                }
                boolean authorized = true;
                if (!(QueryManager.isNull(query.get("calcFieldsSecurity")) || QueryManager.isNull((obj = query.get("calcFieldsSecurity").getAsJsonObject()).get((String)entry.getKey())) || QueryManager.isNull(obj.get((String)entry.getKey()).getAsJsonObject().get("get")))) {
                    String security = obj.get((String)entry.getKey()).getAsJsonObject().get("get").getAsString();
                    if (security == null) {
                        security = "public";
                    }
                    String[] roles = security.split(";");
                    authorized = false;
                    for (String role : roles) {
                        if (role.equalsIgnoreCase("public") || role.equalsIgnoreCase("permitAll")) {
                            authorized = true;
                            break;
                        }
                        if (role.equalsIgnoreCase("authenticated")) {
                            boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                            if (authorized) break;
                        }
                        if (!authorized) {
                            for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                                if (!authority.getAuthority().equalsIgnoreCase(role)) continue;
                                authorized = true;
                                break;
                            }
                        }
                        if (authorized) break;
                    }
                }
                if (!authorized) continue;
                if (post) {
                    if (!(ds instanceof DataSource)) continue;
                    newProperties.put((CallSite)((Object)(((DataSource)ds).getEntity() + "." + (String)entry.getKey())), (JsonElement)entry.getValue());
                    continue;
                }
                try {
                    cronapi.json.Operations.setJsonOrMapField(Var.valueOf(ds), Var.valueOf(entry.getKey()), Var.valueOf(entry.getValue()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void checkMultiTenant(JsonObject query, DataSource ds) {
        if (!QueryManager.isNull(query.get("multiTenant")) && !query.get("multiTenant").getAsBoolean()) {
            ds.disableMultiTenant();
        }
        if (!QueryManager.isNull(query.get("query"))) {
            if (query.get("query").isJsonObject()) {
                JsonObject obj = query.get("query").getAsJsonObject();
                if (!QueryManager.isNull(obj.get("multiTenant")) && !obj.get("multiTenant").getAsBoolean()) {
                    ds.disableMultiTenant();
                }
            } else {
                String jpql = query.get("query").getAsString();
                boolean containsNoTenant = jpql.contains("/*notenant*/");
                if (containsNoTenant) {
                    ds.disableMultiTenant();
                    jpql = jpql.replace("/*notenant*/", "");
                    query.addProperty("query", jpql);
                }
            }
        }
    }

    public static JsonObject createNewQuery(String entityFullName) {
        JsonObject result = new JsonObject();
        String[] splited = entityFullName.split(Pattern.quote("."));
        String simple = splited[splited.length - 1];
        String alias = simple.substring(0, 1).toLowerCase();
        String random = Operations.generateUUID().toString();
        result.addProperty("customId", random);
        result.addProperty("queryName", random);
        result.addProperty("sourceType", "entityFullName");
        result.addProperty("entitySimpleName", simple);
        result.addProperty("entityFullName", entityFullName);
        JsonObject query = new JsonObject();
        query.addProperty("isValid", Boolean.valueOf(true));
        JsonObject ruleEntity = new JsonObject();
        ruleEntity.addProperty("entity", simple);
        ruleEntity.addProperty("alias", alias);
        ruleEntity.addProperty("namespace", entityFullName);
        JsonObject ruleSelect = new JsonObject();
        ruleSelect.addProperty("func", "get");
        ruleSelect.addProperty("field", alias);
        JsonArray rulesEntity = new JsonArray();
        rulesEntity.add((JsonElement)ruleEntity);
        query.add("rulesEntity", (JsonElement)rulesEntity);
        JsonArray rulesSelect = new JsonArray();
        rulesSelect.add((JsonElement)ruleSelect);
        query.add("rulesSelect", (JsonElement)rulesSelect);
        query.add("rulesGroupBy", (JsonElement)new JsonArray());
        query.add("rulesHaving", (JsonElement)new JsonArray());
        query.add("rulesOrderBy", (JsonElement)new JsonArray());
        result.add("query", (JsonElement)query);
        QueryManager.addFilter(result, null, null, null, null);
        return result;
    }

    public static void addFilter(JsonObject query, String field, String type, String operator, String value) {
        JsonObject baseRule;
        if (!QueryManager.isNull(query.get("query").getAsJsonObject().get("rules"))) {
            baseRule = query.get("query").getAsJsonObject().get("rules").getAsJsonObject();
        } else {
            baseRule = new JsonObject();
            baseRule.addProperty("condition", "AND");
            baseRule.addProperty("not", Boolean.valueOf(false));
            baseRule.addProperty("valid", Boolean.valueOf(true));
            baseRule.add("rules", (JsonElement)new JsonArray());
        }
        if (StringUtils.isNotEmpty((CharSequence)field) && StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)operator) && StringUtils.isNotEmpty((CharSequence)value)) {
            JsonArray rules = baseRule.get("rules").getAsJsonArray();
            String alias = query.get("query").getAsJsonObject().get("rulesEntity").getAsJsonArray().get(0).getAsJsonObject().get("alias").getAsString();
            JsonObject currentRule = new JsonObject();
            currentRule.addProperty("id", String.format("%s.%s", alias, field));
            currentRule.addProperty("field", String.format("%s.%s", alias, field));
            currentRule.addProperty("type", type);
            currentRule.addProperty("input", "text");
            currentRule.addProperty("operator", operator);
            currentRule.addProperty("valueIsField", Boolean.valueOf(false));
            currentRule.addProperty("valueType", "param");
            currentRule.addProperty("value", value);
            rules.add((JsonElement)currentRule);
            baseRule.add("rules", (JsonElement)rules);
        }
        query.get("query").getAsJsonObject().add("rules", (JsonElement)baseRule);
    }

    static {
        fromFolder = null;
        DISABLE_AUTH = false;
        freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_28);
        PATTERN_FOR_ID = Pattern.compile("\\/datasources\\/.*?([^\\/]+)\\.datasource\\.json");
        freemarkerBeansWrapper = new BeansWrapperBuilder(freemarkerConfiguration.getIncompatibleImprovements()).build();
        DEFAULT_AUTHORITIES = new JsonArray();
        DEFAULT_AUTHORITIES.add("authenticated");
    }
}

