/*
 * Decompiled with CFR 0.152.
 */
package cronapi.authentication;

import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.Variable;
import cronapi.VariableFactory;
import cronapi.database.DataSource;
import cronapi.util.SecurityUtil;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.mailer.MailerApi;
import cronapp.framework.templater.TemplaterApi;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.encrypt.Encryptors;

@CronapiMetaData(category=CronapiMetaData.CategoryType.AUTHENTICATION, categoryTags={"Autentica\u00e7\u00e3o", "Authentication"})
public class Operations {
    @CronapiMetaData(type="function", name="{{getUserRoles}}", nameTags={"listar", "list", "regras", "roles", "papeis", "grupos"}, description="{{getUserRolesDescription}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var getUserRoles() throws Exception {
        LinkedList<String> groups = new LinkedList<String>();
        for (SecurityUtil.SecurityGroup obj : SecurityUtil.getRoles()) {
            groups.add(obj.id);
        }
        return Var.valueOf(groups);
    }

    @CronapiMetaData(type="function", name="{{normalize}}", nameTags={"normalizar", "normalize", "regras", "roles", "papeis", "grupos"}, description="{{normalizeDesc}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var normalize(@ParamMetaData(description="{{entity}}") Var entity) throws Exception {
        Var valueNormalized;
        Var name = cronapi.object.Operations.getObjectField(entity, Var.valueOf("name"));
        Var userName = cronapi.object.Operations.getObjectField(entity, Var.valueOf("userName"));
        Var email = cronapi.object.Operations.getObjectField(entity, Var.valueOf("email"));
        if (!StringUtils.isEmpty((CharSequence)name.getObjectAsString())) {
            valueNormalized = cronapi.text.Operations.normalize(name);
            cronapi.object.Operations.setObjectField(entity, Var.valueOf("normalizedName"), valueNormalized);
        }
        if (!StringUtils.isEmpty((CharSequence)userName.getObjectAsString())) {
            valueNormalized = cronapi.text.Operations.normalize(userName);
            cronapi.object.Operations.setObjectField(entity, Var.valueOf("normalizedUsername"), valueNormalized);
        }
        if (!StringUtils.isEmpty((CharSequence)email.getObjectAsString())) {
            valueNormalized = cronapi.text.Operations.normalize(email);
            cronapi.object.Operations.setObjectField(entity, Var.valueOf("normalizedEmail"), valueNormalized);
        }
        return entity;
    }

    @CronapiMetaData(type="function", name="{{beforeInsert}}", nameTags={"before", "insert", "regras", "roles", "papeis", "grupos", "antes", "inserir"}, description="{{beforeInsertDesc}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var beforeInsert(@ParamMetaData(description="{{entity}}") Var entity) throws Exception {
        entity = Var.valueOf(Operations.normalize(entity));
        return entity;
    }

    @CronapiMetaData(type="function", name="{{beforeUpdate}}", nameTags={"before", "insert", "regras", "roles", "papeis", "grupos", "antes", "atualizar"}, description="{{beforeUpdateDesc}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var beforeUpdate(@ParamMetaData(description="{{entity}}") Var entity) throws Exception {
        entity = Var.valueOf(Operations.normalize(entity));
        return entity;
    }

    @CronapiMetaData(type="function", name="{{beforeDelete}}", nameTags={"before", "delete", "regras", "roles", "papeis", "grupos", "antes", "deletar"}, description="{{beforeDeleteDesc}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var beforeDelete(@ParamMetaData(description="{{entity}}") Var entity) throws Exception {
        Var administrators;
        Var authorizations = cronapi.database.Operations.query(Var.valueOf("app.entity.UserRole"), Var.valueOf("select u from UserRole u where u.user = :user AND u.role.normalizedName = :roleNormalizedName"), Var.valueOf("user", entity), Var.valueOf("roleNormalizedName", Var.valueOf("administrators")));
        if (Var.valueOf(cronapi.list.Operations.size(authorizations).compareTo(Var.valueOf(0)) > 0).getObjectAsBoolean().booleanValue() && Var.valueOf(cronapi.list.Operations.size(administrators = cronapi.database.Operations.query(Var.valueOf("app.entity.UserRole"), Var.valueOf("select u.user from UserRole u where u.role.normalizedName = :roleNormalizedName"), Var.valueOf("roleNormalizedName", Var.valueOf("administrators")))).compareTo(Var.valueOf(1)) > 0).negate().getObjectAsBoolean().booleanValue()) {
            cronapi.util.Operations.throwException(cronapi.util.Operations.createException(cronapi.i18n.Operations.translate(Var.valueOf("OnlyOneAdministrator"), new Var[0])));
        }
        return entity;
    }

    @CronapiMetaData(type="function", name="{{signUp}}", nameTags={"sign up", "register", "cadastrar", "inscrever"}, description="{{signUpParam0}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var defaultSignUp(@ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{signUpParam0}}") Var params) throws Exception {
        Var httpReturnStatus = Var.VAR_NULL;
        Var error = Var.VAR_NULL;
        try {
            httpReturnStatus = Operations.signUp(params);
        }
        catch (Exception error_exception) {
            error = Var.valueOf(error_exception);
            cronapi.util.Operations.log(Var.valueOf("General"), Var.valueOf("SEVERE"), cronapi.json.Operations.getJsonOrMapField(error, Var.valueOf("message")), error);
        }
        return httpReturnStatus;
    }

    public static Var signUp(@ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{signUpParam0}}") Var params) throws Exception {
        Var retorno = new Var();
        try {
            Var orign = cronapi.screen.Operations.getHeader(Var.valueOf("Origin"));
            if (orign.getObjectAsString().contains("//localhost")) {
                orign = Var.valueOf(RestClient.getRestClient().getServerAddress());
            }
            StringBuilder uriBuilder = new StringBuilder().append(orign).append("/auth/signup");
            retorno = cronapi.util.Operations.getURLFromOthers(Var.valueOf("POST"), Var.valueOf("application/json"), new Var(uriBuilder.toString()), Var.VAR_NULL, Var.VAR_NULL, params);
        }
        catch (Exception err) {
            cronapi.util.Operations.log(Var.valueOf("General"), Var.valueOf("SEVERE"), cronapi.json.Operations.getJsonOrMapField(new Var(err), Var.valueOf("message")), Var.VAR_NULL);
        }
        return Var.valueOf(retorno);
    }

    @CronapiMetaData(type="function", name="{{resetPassword}}", nameTags={"reset password", "recover password", "recuperar senha", "resetar senha"}, description="{{resetPasswordDescription}}", params={"{{resetPasswordParam0}}", "{{resetPasswordParam1}}", "{{resetPasswordParam2}}", "{{isMobile}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.BOOLEAN})
    public static Var defaultResetPassword(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam0}}") Var email, @ParamMetaData(defaultValue="https://acesso.cronapp.io/img/header.png", type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam1}}") Var imageHeader, @ParamMetaData(defaultValue="https://acesso.cronapp.io/img/footer.png", type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam2}}") Var imageFooter, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="{{isMobile}}") Var useOneTimePassword) throws Exception {
        try {
            return new Var(Operations.resetPassword(email, imageHeader, imageFooter, useOneTimePassword));
        }
        catch (Exception exception) {
            Var error = Var.valueOf(exception);
            cronapi.util.Operations.log(Var.valueOf("General"), Var.valueOf("SEVERE"), cronapi.json.Operations.getJsonOrMapField(error, Var.valueOf("message")), error);
            throw exception;
        }
    }

    public static String resetPassword(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam0}}") Var toAddress, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam1}}") Var imageHeader, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{resetPasswordParam2}}") Var imageFooter, @ParamMetaData(type=CronapiMetaData.ObjectType.BOOLEAN, description="{{isMobile}}") Var useOneTimePassword) throws Exception {
        DataSource ds = new DataSource("app.entity.User");
        ds.filter("select u.name, u.email from User u where u.email = :email", Var.valueOf("email", toAddress));
        if (!ds.getPage().getContent().isEmpty()) {
            LinkedHashMap<String, Object> dataModel = new LinkedHashMap<String, Object>();
            HashMap<String, String> claims = new HashMap<String, String>();
            CronappSettingsService settingsService = (CronappSettingsService)CronappConfiguration.getBean(CronappSettingsService.class);
            claims.put("sub", toAddress.getObjectAsString());
            claims.put("scope", "update:current_user:password");
            if (useOneTimePassword != null && Boolean.TRUE.equals(useOneTimePassword.getObjectAsBoolean())) {
                String oneTimePassword = RandomStringUtils.randomAlphanumeric((int)9).toUpperCase();
                String encryptedOneTimePassword = Encryptors.text((CharSequence)settingsService.getEncryptionKey(), (CharSequence)settingsService.getEncryptionSalt()).encrypt(oneTimePassword);
                claims.put("otp", encryptedOneTimePassword);
                dataModel.put("oneTimePassword", oneTimePassword);
            }
            long expiration = AppConfig.tokenExpiration();
            Date tokenExpiration = new Date(System.currentTimeMillis() + expiration * 1000L);
            String token = Jwts.builder().setClaims(claims).setExpiration(tokenExpiration).signWith(SignatureAlgorithm.HS512, AppConfig.token()).compact();
            String url = RestClient.getRestClient().getHeader("Origin") + "/#/public/reset-password?token=" + token;
            dataModel.put("link", url);
            dataModel.put("email", toAddress);
            JsonObject config = AppConfig.getJSON();
            String emailFrom = "";
            String nameFrom = "";
            if (!AppConfig.isNull(config.get("email"))) {
                emailFrom = config.get("email").getAsJsonObject().get("emailResetPassword").getAsString();
                nameFrom = config.get("email").getAsJsonObject().get("nameResetPassword").getAsString();
            }
            Variable message = (Variable)MailerApi.createMessage();
            MailerApi.setFrom((Variable)message, (Variable)VariableFactory.getInstance().newVariable((Object)emailFrom), (Variable)VariableFactory.getInstance().newVariable((Object)nameFrom));
            MailerApi.addTo((Variable)message, (Variable)toAddress, (Variable)toAddress);
            MailerApi.setSubject((Variable)message, (Variable)VariableFactory.getInstance().newVariable((Object)cronapi.i18n.Operations.translate(Var.valueOf("ResetPasswordEmailSubject"), new Var[0])));
            MailerApi.setText((Variable)message, (Variable)VariableFactory.getInstance().newVariable((Object)""), (Variable)TemplaterApi.process((Variable)new Var("reset-password.ftlh"), (Variable)new Var(dataModel), (Variable)VariableFactory.getInstance().newVariable((Object)RestClient.getRestClient().getLocale())));
            MailerApi.addInlineAttachment((Variable)VariableFactory.getInstance().newVariable((Object)"headerImageCid"), (Variable)message, (Variable)imageHeader);
            MailerApi.addInlineAttachment((Variable)VariableFactory.getInstance().newVariable((Object)"footerImageCid"), (Variable)message, (Variable)imageFooter);
            MailerApi.send((Variable)message);
            return token;
        }
        return "";
    }
}

