/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest.security;

import cronapi.RestClient;
import cronapi.i18n.Messages;
import cronapi.rest.security.CronappSecurity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;

public class BlocklySecurity {
    public static void checkSecurity(Class clazz, String method) throws Exception {
        if (clazz != null) {
            String[] authorities;
            boolean authorized;
            String value = null;
            for (Annotation annotation : clazz.getAnnotations()) {
                Method type;
                if (!annotation.annotationType().getName().equals("cronapi.rest.security.CronappSecurity") || (type = annotation.annotationType().getMethod(method.toLowerCase(), new Class[0])) == null) continue;
                value = (String)type.invoke((Object)annotation, new Object[0]);
            }
            if (value == null || value.isEmpty()) {
                value = "Authenticated";
            }
            if (!(authorized = BlocklySecurity.isAuthorized(authorities = value.trim().split(";")))) {
                throw new RuntimeException(Messages.getString("notAllowed"));
            }
        }
    }

    public static String getRequestMethodSecurity(CronappSecurity beanSecurity, String method) {
        String result = null;
        if (StringUtils.equals((CharSequence)"GET", (CharSequence)method)) {
            result = beanSecurity.get();
        } else if (StringUtils.equals((CharSequence)"POST", (CharSequence)method)) {
            result = beanSecurity.post();
        } else if (StringUtils.equals((CharSequence)"PUT", (CharSequence)method)) {
            result = beanSecurity.put();
        } else if (StringUtils.equals((CharSequence)"DELETE", (CharSequence)method)) {
            result = beanSecurity.delete();
        } else if (StringUtils.equals((CharSequence)"FILTER", (CharSequence)method)) {
            result = beanSecurity.filter();
        } else if (StringUtils.equals((CharSequence)"EXECUTE", (CharSequence)method)) {
            result = beanSecurity.execute();
        }
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{result, "Authenticated"});
    }

    public static boolean isAuthorized(String[] authorities) {
        boolean authorized = false;
        block0: for (String role : authorities) {
            if (role.equalsIgnoreCase("authenticated")) {
                boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                if (authorized) break;
            }
            if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                authorized = true;
                break;
            }
            for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                authorized = true;
                continue block0;
            }
        }
        return authorized;
    }
}

