/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import cronapi.util.GsonUTCDateAdapter;
import cronapi.util.Operations;
import jakarta.persistence.Id;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryListener
extends DescriptorEventAdapter {
    private static final Logger log = LoggerFactory.getLogger(HistoryListener.class);
    public static final String CURRENT_IP = HistoryListener.getCurrentIp();
    public static GsonUTCDateAdapter UTC_DATE_ADAPTER = new GsonUTCDateAdapter();
    private static DatabaseQueryManager LOG_MANAGER;

    public static DatabaseQueryManager getAuditLogManager() {
        DatabaseQueryManager logManager = null;
        try {
            logManager = Operations.IS_DEBUG ? new DatabaseQueryManager("auditlogquery", false) : LOG_MANAGER;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logManager;
    }

    public void postUpdate(DescriptorEvent event) {
        this.beforeAnyOperation(event, "UPDATE");
    }

    public void postInsert(DescriptorEvent event) {
        this.beforeAnyOperation(event, "INSERT");
    }

    public void postDelete(DescriptorEvent event) {
        this.beforeAnyOperation(event, "DELETE");
    }

    private static String getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private void beforeAnyOperation(DescriptorEvent event, String operation) {
        try {
            DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
            if (logManager != null) {
                final Object object = event.getObject();
                String namespace = object.getClass().getPackage().getName().replace(".entity", "");
                GsonBuilder builder = new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

                    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                        return fieldAttributes.getDeclaringClass() != object.getClass() && fieldAttributes.getAnnotation(Id.class) == null;
                    }

                    public boolean shouldSkipClass(Class<?> aClass) {
                        return false;
                    }
                });
                builder.registerTypeAdapter(Date.class, (Object)UTC_DATE_ADAPTER);
                Gson gson = builder.create();
                JsonElement objectJson = gson.toJsonTree(object);
                JsonArray affected = null;
                if (event.getQuery() instanceof UpdateObjectQuery) {
                    affected = new JsonArray();
                    for (String field : ((UpdateObjectQuery)event.getQuery()).getObjectChangeSet().getChangedAttributeNames()) {
                        affected.add(field);
                    }
                }
                Var auditLog = new Var(new LinkedHashMap());
                auditLog.set("type", object.getClass().getName());
                auditLog.set("command", operation);
                auditLog.set("category", "Entity");
                auditLog.set("date", new Date());
                auditLog.set("objectData", objectJson.toString());
                if (RestClient.getRestClient() != null) {
                    auditLog.set("user", RestClient.getRestClient().getUser() != null ? RestClient.getRestClient().getUser().getUsername() : null);
                    auditLog.set("host", RestClient.getRestClient().getHost());
                    auditLog.set("agent", RestClient.getRestClient().getAgent());
                }
                auditLog.set("server", CURRENT_IP);
                auditLog.set("affectedFields", affected != null ? affected.toString() : null);
                auditLog.set("application", AppConfig.guid());
                if (logManager.isDatabase() && logManager.getEntity().startsWith(namespace + ".")) {
                    logManager.insertAfterCommit(event.getSession(), auditLog, new Object[0]);
                } else {
                    logManager.insert(auditLog, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            LOG_MANAGER = new DatabaseQueryManager("auditlogquery", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

