/*
 * Decompiled with CFR 0.152.
 */
package cronapi.pushnotification;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.pushnotification.FirebasePushNotificationService;
import cronapi.pushnotification.HeaderRequestInterceptor;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.http.HttpEntity;
import org.springframework.web.client.RestTemplate;

@CronapiMetaData(category=CronapiMetaData.CategoryType.UTIL, categoryTags={"UTIL", "Util"})
public class Operations {
    @Deprecated
    @CronapiMetaData(type="function", name="{{firebaseSendNotification}}", nameTags={"SendNotification", "@deprecated"}, description="{{firebaseSendNotificationDescription}}")
    public static final void sendNotification(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{FirebaseTo}}") Var paramTo, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseTitle}}") Var paramTitle, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseSubtitle}}") Var paramSubtitle, @ParamMetaData(type=CronapiMetaData.ObjectType.JSON, description="{{FirebaseData}}") Var paramData) throws Exception {
        JsonObject body = new JsonObject();
        body.addProperty("to", paramTo.getObjectAsString());
        body.addProperty("priority", "high");
        if (!paramTitle.isEmptyOrNull().booleanValue() && !paramSubtitle.isEmptyOrNull().booleanValue()) {
            JsonObject notification = new JsonObject();
            notification.addProperty("title", paramTitle.getObjectAsString());
            notification.addProperty("body", paramSubtitle.getObjectAsString());
            notification.addProperty("icon", "notification_icon");
            body.add("notification", (JsonElement)notification);
        }
        if (!paramData.isNull().booleanValue() && paramData.getObjectAsJson() != null) {
            body.add("data", (JsonElement)paramData.getObjectAsJson().getAsJsonObject());
        }
        HttpEntity request = new HttpEntity((Object)body.toString());
        FirebasePushNotificationService firebaseService = new FirebasePushNotificationService(serverKey.getObjectAsString());
        CompletableFuture<String> pushNotification = firebaseService.send((HttpEntity<String>)request);
        CompletableFuture.allOf(pushNotification).join();
        try {
            String string = pushNotification.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @CronapiMetaData(type="function", name="{{firebaseSendNotification}}", nameTags={"SendNotification"}, description="{{firebaseSendNotificationDescription}}")
    public static final void sendNotificationV2(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebasePrivateKeyPem}}") Var privateKeyPem, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseClientEmail}}") Var clientEmail, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseProjectId}}") Var projectId, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{FirebaseTo}}") Var paramTo, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseTitle}}") Var paramTitle, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseBody}}") Var paramBody, @ParamMetaData(type=CronapiMetaData.ObjectType.JSON, description="{{FirebaseData}}") Var paramData) throws Exception {
        try {
            PrivateKey privateKey = Operations.getPrivateKeyFromPem(privateKeyPem.getObjectAsString());
            String jwt = Operations.createJwtToken(clientEmail.getObjectAsString(), privateKey);
            String accessToken = Operations.getAccessToken(jwt);
            JsonObject message = new JsonObject();
            message.addProperty("token", paramTo.getObjectAsString());
            if (!paramTitle.isEmptyOrNull().booleanValue() && !paramBody.isEmptyOrNull().booleanValue()) {
                JsonObject notification = new JsonObject();
                notification.addProperty("title", paramTitle.getObjectAsString());
                notification.addProperty("body", paramBody.getObjectAsString());
                message.add("notification", (JsonElement)notification);
            }
            if (!paramData.isNull().booleanValue() && paramData.getObjectAsJson() != null) {
                message.add("data", (JsonElement)paramData.getObjectAsJson().getAsJsonObject());
            }
            JsonObject requestBody = new JsonObject();
            requestBody.add("message", (JsonElement)message);
            HttpEntity request = new HttpEntity((Object)requestBody.toString());
            FirebasePushNotificationService firebaseService = new FirebasePushNotificationService();
            CompletableFuture<String> pushNotification = firebaseService.sendV2((HttpEntity<String>)request, accessToken, projectId.getObjectAsString());
            CompletableFuture.allOf(pushNotification).join();
            try {
                String firebaseResponse = pushNotification.get();
                System.out.println("Resposta do Firebase: " + firebaseResponse);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new RuntimeException("Erro ao obter resposta do Firebase: " + e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Erro ao enviar notifica\u00e7\u00e3o: " + e.getMessage());
        }
    }

    public static PrivateKey getPrivateKeyFromPem(String pem) throws Exception {
        String cleanPem = pem.replaceAll("-----\\w+ PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] keyBytes = Base64.getDecoder().decode(cleanPem);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(spec);
    }

    public static String createJwtToken(String clientEmail, PrivateKey privateKey) throws Exception {
        JsonObject header = new JsonObject();
        header.addProperty("alg", "RS256");
        header.addProperty("typ", "JWT");
        JsonObject payload = new JsonObject();
        payload.addProperty("iss", clientEmail);
        payload.addProperty("scope", "https://www.googleapis.com/auth/firebase.messaging");
        payload.addProperty("aud", "https://oauth2.googleapis.com/token");
        payload.addProperty("iat", (Number)(System.currentTimeMillis() / 1000L));
        payload.addProperty("exp", (Number)((System.currentTimeMillis() + 3600000L) / 1000L));
        String encodedHeader = Base64.getUrlEncoder().withoutPadding().encodeToString(header.toString().getBytes("UTF-8"));
        String encodedPayload = Base64.getUrlEncoder().withoutPadding().encodeToString(payload.toString().getBytes("UTF-8"));
        String unsignedToken = encodedHeader + "." + encodedPayload;
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(unsignedToken.getBytes("UTF-8"));
        String signedToken = Base64.getUrlEncoder().withoutPadding().encodeToString(signature.sign());
        return unsignedToken + "." + signedToken;
    }

    public static String getAccessToken(String jwt) throws Exception {
        URL url = new URL("https://oauth2.googleapis.com/token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        String postData = "grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + jwt;
        OutputStream os = conn.getOutputStream();
        os.write(postData.getBytes("UTF-8"));
        os.flush();
        os.close();
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            String response = new String(conn.getInputStream().readAllBytes(), "UTF-8");
            Gson gson = new Gson();
            JsonObject responseJson = (JsonObject)gson.fromJson(response, JsonObject.class);
            return responseJson.get("access_token").getAsString();
        }
        String errorResponse = new String(conn.getErrorStream().readAllBytes(), "UTF-8");
        throw new RuntimeException("Falha ao obter token de acesso. C\u00f3digo de resposta: " + responseCode + ". Resposta: " + errorResponse);
    }

    @CronapiMetaData(type="function", name="{{firebaseSendRawNotification}}", nameTags={"SendNotification"}, description="{{firebaseSendRawNotificationDescription}}")
    public static final void sendRawNotification(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{FirebaseTo}}") Var paramTo, @ParamMetaData(type=CronapiMetaData.ObjectType.JSON, description="{{FirebaseBody}}") Var paramBody) throws Exception {
        JsonObject body = (JsonObject)new Gson().fromJson(paramBody.getObjectAsString(), JsonObject.class);
        body.addProperty("to", paramTo.getObjectAsString());
        body.addProperty("priority", "high");
        HttpEntity request = new HttpEntity((Object)body.toString());
        FirebasePushNotificationService firebaseService = new FirebasePushNotificationService(serverKey.getObjectAsString());
        CompletableFuture<String> pushNotification = firebaseService.send((HttpEntity<String>)request);
        CompletableFuture.allOf(pushNotification).join();
        try {
            String string = pushNotification.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @CronapiMetaData(type="function", name="{{firebaseRegister}}", nameTags={"Firebase", "Topic", "Register", "Registrar"}, description="{{firebaseRegisterDescription}}")
    public static void firebaseRegister(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseTopicName}}") Var topicName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseToken}}") Var token) throws Exception {
        String baseUrl = "https://iid.googleapis.com/iid/v1/";
        String topicUrl = "/rel/topics/";
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<HeaderRequestInterceptor> interceptors = new ArrayList<HeaderRequestInterceptor>();
        interceptors.add(new HeaderRequestInterceptor("Authorization", "key=" + serverKey.toString()));
        interceptors.add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        restTemplate.setInterceptors(interceptors);
        HttpEntity request = new HttpEntity((Object)"");
        if (token.getType().equals((Object)Var.Type.LIST)) {
            for (Object tokenItem : token.getObjectAsList()) {
                String url = baseUrl + Var.valueOf(tokenItem).getObjectAsString() + topicUrl + topicName.getObjectAsString();
                restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            }
        } else {
            String url = baseUrl + token.getObjectAsString() + topicUrl + topicName.getObjectAsString();
            restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        }
    }
}

