/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class ReflectionUtils {
    public static void setField(Object obj, String name, Object value) {
        try {
            Field field;
            try {
                field = obj.getClass().getDeclaredField(name);
            }
            catch (Exception e) {
                field = obj.getClass().getSuperclass().getDeclaredField(name);
            }
            if (field != null) {
                field.setAccessible(true);
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getField(Object obj, String name) {
        try {
            Field field;
            try {
                field = obj.getClass().getDeclaredField(name);
            }
            catch (Exception e) {
                field = obj.getClass().getSuperclass().getDeclaredField(name);
            }
            if (field != null) {
                field.setAccessible(true);
                return field.get(obj);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static Annotation getAnnotation(Parameter obj, String name) {
        for (Annotation annotation : obj.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(name)) continue;
            return annotation;
        }
        return null;
    }

    public static Method getMethod(Object o, String name) {
        if (o != null) {
            Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
            for (Method m : clazz.getMethods()) {
                if (!m.getName().equalsIgnoreCase(name)) continue;
                return m;
            }
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(name)) continue;
                return m;
            }
        }
        return null;
    }
}

