/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import cronapi.Var;
import cronapi.database.JPAUtil;
import cronapi.odata.server.BlocklyQuery;
import cronapi.util.ReflectionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

public class JPQLParserUtil {
    public static IdentificationVariableDeclaration getIdentificationVariableDeclaration(JPQLExpression jpqlExpression) {
        SelectStatement selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
        Expression declaration = ((FromClause)selectStatement.getFromClause()).getDeclaration();
        IdentificationVariableDeclaration identificationVariableDeclaration = null;
        if (declaration instanceof IdentificationVariableDeclaration) {
            identificationVariableDeclaration = (IdentificationVariableDeclaration)((FromClause)selectStatement.getFromClause()).getDeclaration();
        }
        if (declaration instanceof CollectionExpression) {
            CollectionExpression collectionExpression = (CollectionExpression)((FromClause)selectStatement.getFromClause()).getDeclaration();
            identificationVariableDeclaration = (IdentificationVariableDeclaration)collectionExpression.getChild(0);
        }
        return identificationVariableDeclaration;
    }

    public static String getMainEntity(JPQLExpression jpqlExpression) {
        IdentificationVariableDeclaration identificationVariableDeclaration = JPQLParserUtil.getIdentificationVariableDeclaration(jpqlExpression);
        RangeVariableDeclaration rangeVariableDeclaration = (RangeVariableDeclaration)identificationVariableDeclaration.getRangeVariableDeclaration();
        return rangeVariableDeclaration.getRootObject().toString();
    }

    public static String getMainAlias(JPQLExpression jpqlExpression) {
        IdentificationVariableDeclaration identificationVariableDeclaration = JPQLParserUtil.getIdentificationVariableDeclaration(jpqlExpression);
        RangeVariableDeclaration rangeVariableDeclaration = (RangeVariableDeclaration)identificationVariableDeclaration.getRangeVariableDeclaration();
        return rangeVariableDeclaration.getIdentificationVariable().toString();
    }

    public static long countAsLong(String jpql, Query query, EntityManager em) {
        Query countNativeQuery = JPQLParserUtil.count(jpql, query, em);
        return (Long)countNativeQuery.getResultList().get(0);
    }

    public static Query count(String jpql, Query query, EntityManager em) {
        String jpqlStatement = jpql;
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
        SelectStatement selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
        String selection = ((SelectClause)selectStatement.getSelectClause()).getSelectExpression().toActualText();
        String distinct = ((SelectClause)selectStatement.getSelectClause()).getActualDistinctIdentifier();
        boolean hasDistinct = ((SelectClause)selectStatement.getSelectClause()).hasDistinct();
        boolean needGroupByInDistinct = hasDistinct && selection.contains(",");
        String mainAlias = JPQLParserUtil.getMainAlias(jpqlExpression);
        String selectExpression = null;
        ReflectionUtils.setField(selectStatement, "selectClause", null);
        selectExpression = hasDistinct ? (needGroupByInDistinct ? "SELECT count(" + distinct + " " + mainAlias + ") " : "SELECT count(" + distinct + " " + selection + ") ") : "SELECT count(" + mainAlias + ") ";
        if (selectStatement.hasOrderByClause()) {
            ReflectionUtils.setField(selectStatement, "orderByClause", null);
        }
        selectExpression = selectExpression + selectStatement.toString();
        if (needGroupByInDistinct) {
            selectExpression = selectExpression + " GROUP BY " + selection;
        }
        Query countQuery = em.createQuery(selectExpression.toString());
        JPAUtil.prepareQuery(countQuery);
        for (Parameter p : query.getParameters()) {
            try {
                if (p.getName() == null) {
                    countQuery.setParameter(String.valueOf(p.getPosition()), query.getParameterValue(p.getPosition().intValue()));
                    continue;
                }
                countQuery.setParameter(p.getName(), query.getParameterValue(p.getName()));
            }
            catch (Exception exception) {}
        }
        return countQuery;
    }

    public static Query countNative(String jpql, Query query, EntityManager em) {
        AbstractSession session = (AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession();
        String jpqlStatement = jpql;
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
        SelectStatement selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
        if (selectStatement.hasOrderByClause()) {
            ReflectionUtils.setField(selectStatement, "orderByClause", null);
        }
        jpql = selectStatement.toString();
        Query countQuery = em.createQuery(jpql);
        JPAUtil.prepareQuery(countQuery);
        LinkedList<Object> arguments = new LinkedList<Object>();
        for (Parameter p : query.getParameters()) {
            if (p.getName() == null) {
                countQuery.setParameter(p.getPosition().intValue(), query.getParameterValue(p.getPosition().intValue()));
                arguments.add(query.getParameterValue(p.getPosition().intValue()));
                continue;
            }
            countQuery.setParameter(p.getName(), query.getParameterValue(p.getName()));
            arguments.add(query.getParameterValue(p.getName()));
        }
        DatabaseQuery databaseQuery = ((EJBQueryImpl)countQuery.unwrap(EJBQueryImpl.class)).getDatabaseQuery();
        databaseQuery.prepareCall((Session)session, (DataRecord)new DatabaseRecord());
        AbstractRecord r = databaseQuery.rowFromArguments(arguments, session);
        String sql = databaseQuery.getTranslatedSQLString((Session)session, (DataRecord)r);
        sql = sql.replace("ESCAPE '\\'", "");
        String countSql = "select count(*) AS CRONAPP_COUNT from (" + sql + ") as CRONAPP_COUNT_SELECT";
        Query countNativeQuery = em.createNativeQuery(countSql);
        return countNativeQuery;
    }

    public static List<String> getNonWhereParams(String jpql) {
        String jpqlStatement = jpql;
        JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
        Expression selectStatement = jpqlExpression.getQueryStatement();
        if (selectStatement != null) {
            try {
                ReflectionUtils.setField(selectStatement, "whereClause", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ReflectionUtils.setField(selectStatement, "groupByClause", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ReflectionUtils.setField(selectStatement, "havingClause", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jpqlStatement = selectStatement.toString();
        }
        return JPQLParserUtil.parseParams(jpqlStatement);
    }

    public static ODataInfo addODdataRequest(String jpql, Var[] queryParams) {
        try {
            BlocklyQuery blocklyQuery = BlocklyQuery.CURRENT_BLOCK_QUERY.get();
            if (blocklyQuery != null) {
                Object jpqlStatement = jpql;
                JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
                SelectStatement selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
                String alias = null;
                String having = null;
                String groupBy = null;
                Object orderBy = null;
                String mainAlias = JPQLParserUtil.getMainAlias(jpqlExpression);
                String selection = ((SelectClause)selectStatement.getSelectClause()).getSelectExpression().toActualText();
                if (!selection.contains(".") && !selection.contains(",")) {
                    alias = mainAlias;
                }
                String whereExpression = null;
                ODataInfo info = new ODataInfo();
                if (blocklyQuery.getUriInfo().getFilter() != null || blocklyQuery.getUriInfo().getKeyPredicates().size() > 0) {
                    List<String> paramsWithName;
                    List<String> params;
                    if (blocklyQuery.getUriInfo().getFilter() != null) {
                        whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)blocklyQuery.getUriInfo().getFilter(), (String)alias, (String)"?", (String)"jpa");
                    }
                    if (blocklyQuery.getUriInfo().getKeyPredicates().size() > 0) {
                        whereExpression = ODataExpressionParser.parseKeyPredicates((List)blocklyQuery.getUriInfo().getKeyPredicates(), (String)alias, (String)"?", (String)"jpa", (String)"POST");
                    }
                    List<String> list = params = whereExpression != null ? JPQLParserUtil.parseParams(whereExpression, '?') : null;
                    if (blocklyQuery.getUriInfo().getFilter() != null) {
                        whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)blocklyQuery.getUriInfo().getFilter(), (String)alias, (String)":crn_param_", (String)"jpa");
                    }
                    if (blocklyQuery.getUriInfo().getKeyPredicates().size() > 0) {
                        whereExpression = ODataExpressionParser.parseKeyPredicates((List)blocklyQuery.getUriInfo().getKeyPredicates(), (String)alias, (String)":crn_param_", (String)"jpa", (String)"POST");
                    }
                    List<String> list2 = paramsWithName = whereExpression != null ? JPQLParserUtil.parseParams(whereExpression, ':') : null;
                    if (paramsWithName != null && params != null) {
                        int i = 0;
                        info.params = new Var[queryParams.length + params.size()];
                        Var[] varArray = queryParams;
                        int n = varArray.length;
                        for (int j = 0; j < n; ++j) {
                            Var v;
                            info.params[i] = v = varArray[j];
                            ++i;
                        }
                        for (String p : params) {
                            info.params[i] = Var.valueOf(paramsWithName.get(i), blocklyQuery.getParameterValue(p));
                            ++i;
                        }
                    }
                }
                String where = null;
                if (selectStatement != null && selectStatement.hasOrderByClause()) {
                    orderBy = ((OrderByClause)selectStatement.getOrderByClause()).toString();
                    ReflectionUtils.setField(selectStatement, "orderByClause", null);
                    jpqlStatement = selectStatement.toString();
                }
                if (blocklyQuery.getUriInfo().getOrderBy() != null) {
                    String orderExpression = ODataExpressionParser.parseToJPAOrderByExpression((OrderByExpression)blocklyQuery.getUriInfo().getOrderBy(), (String)alias, (String)":crn_param_", (String)"jpa");
                    orderBy = "ORDER BY " + orderExpression;
                }
                if (selectStatement != null && selectStatement.hasWhereClause()) {
                    where = ((WhereClause)selectStatement.getWhereClause()).getConditionalExpression().toString();
                    ReflectionUtils.setField(selectStatement, "whereClause", null);
                    jpqlStatement = selectStatement.toString();
                }
                if (selectStatement != null && selectStatement.hasGroupByClause()) {
                    groupBy = ((GroupByClause)selectStatement.getGroupByClause()).toString();
                    ReflectionUtils.setField(selectStatement, "groupByClause", null);
                    jpqlStatement = selectStatement.toString();
                }
                if (selectStatement != null && selectStatement.hasHavingClause()) {
                    having = ((HavingClause)selectStatement.getHavingClause()).toString();
                    ReflectionUtils.setField(selectStatement, "havingClause", null);
                    jpqlStatement = selectStatement.toString();
                }
                if (whereExpression != null) {
                    jpqlStatement = where != null ? (String)jpqlStatement + " WHERE (" + where + ") AND " + whereExpression : (String)jpqlStatement + " WHERE " + whereExpression;
                } else if (where != null) {
                    jpqlStatement = (String)jpqlStatement + " WHERE " + where;
                }
                if (having != null) {
                    jpqlStatement = (String)jpqlStatement + " " + having;
                }
                if (groupBy != null) {
                    jpqlStatement = (String)jpqlStatement + " " + groupBy;
                }
                if (orderBy != null) {
                    jpqlStatement = (String)jpqlStatement + " " + (String)orderBy;
                }
                info.jpql = jpqlStatement;
                if (blocklyQuery.getFirstResult() != -1) {
                    info.first = blocklyQuery.getFirstResult();
                }
                if (blocklyQuery.getMaxResults() != -1) {
                    info.max = blocklyQuery.getMaxResults();
                }
                return info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String replaceToken(String SQL, String name, String value) {
        SQL = ((String)SQL).replace("::", "$$__$$");
        char charDelim = name.charAt(0);
        String delims = " \n\r\t.(){},+=!" + charDelim;
        String quots = "'";
        Object token = "";
        boolean isQuoted = false;
        for (int i = 0; i < ((String)SQL).length(); ++i) {
            if ("'".indexOf(((String)SQL).charAt(i)) != -1) {
                boolean bl = isQuoted = ((String)token).length() == 0;
            }
            if (delims.indexOf(((String)SQL).charAt(i)) == -1 || isQuoted) {
                token = (String)token + ((String)SQL).charAt(i);
                continue;
            }
            if (((String)token).length() > 0) {
                if (((String)token).startsWith("" + charDelim) && ((String)token).substring(1).equals(name.substring(1))) {
                    SQL = ((String)SQL).substring(0, i - ((String)token).length()) + value + ((String)SQL).substring(i);
                    SQL = ((String)SQL).replace("$$__$$", "::");
                    return SQL;
                }
                token = "";
                isQuoted = false;
            }
            if (((String)SQL).charAt(i) != charDelim) continue;
            token = "" + charDelim;
        }
        if (((String)token).length() > 0 && ((String)token).startsWith("" + charDelim) && ((String)token).substring(1).equals(name.substring(1))) {
            SQL = ((String)SQL).substring(0, ((String)SQL).length() - ((String)token).length()) + value;
            SQL = ((String)SQL).replace("$$__$$", "::");
            return SQL;
        }
        SQL = ((String)SQL).replace("$$__$$", "::");
        return SQL;
    }

    public static List<String> parseParams(String SQL) {
        return JPQLParserUtil.parseParams(SQL, ':');
    }

    public static List<String> parseParams(String SQL, char charDelim) {
        return JPQLParserUtil.parseParams(SQL, charDelim, false);
    }

    public static List<String> parseParams(String SQL, char charDelim, boolean distinctParams) {
        SQL = SQL.replace("::", "$$__$$");
        String delims = " \n\r\t.(){},+=!" + charDelim;
        String quots = "'";
        Object token = "";
        boolean isQuoted = false;
        LinkedList<String> tokens = new LinkedList<String>();
        for (int i = 0; i < SQL.length(); ++i) {
            if ("'".indexOf(SQL.charAt(i)) != -1) {
                boolean bl = isQuoted = ((String)token).length() == 0;
            }
            if (delims.indexOf(SQL.charAt(i)) == -1 || isQuoted) {
                token = (String)token + SQL.charAt(i);
                continue;
            }
            if (((String)token).length() > 0) {
                JPQLParserUtil.canAdd(charDelim, distinctParams, (String)token, tokens);
                token = "";
                isQuoted = false;
            }
            if (SQL.charAt(i) != charDelim) continue;
            token = "" + charDelim;
        }
        if (((String)token).length() > 0) {
            JPQLParserUtil.canAdd(charDelim, distinctParams, (String)token, tokens);
        }
        return tokens;
    }

    private static void canAdd(char charDelim, boolean distinctParams, String token, List<String> tokens) {
        if (token.startsWith("" + charDelim)) {
            if (!distinctParams) {
                tokens.add(token.substring(1));
            } else if (!tokens.contains(token.substring(1))) {
                tokens.add(token.substring(1));
            }
        }
    }

    public static class ODataInfo {
        public String jpql;
        public Var[] params;
        public Integer first;
        public Integer max;
    }
}

