/*
 * Decompiled with CFR 0.152.
 */
package cronapi.report;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.report.ReportService;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@CronapiMetaData(category=CronapiMetaData.CategoryType.UTIL, categoryTags={"Report", "Relat\u00f3rio"})
public class Operations {
    private static final String TYPE_PDF = "pdf";
    private static final String TYPE_HTML = "html";
    private static final String TYPE_EXCEL = "excel";

    @CronapiMetaData(type="function", name="{{generateReport}}", nameTags={"generateReport", "GerarRelatorio"}, description="{{generateReportDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT, wizard="procedures_generatereport_callreturn")
    public static final Var generateReport(@ParamMetaData(blockType="util_report_list", type=CronapiMetaData.ObjectType.STRING, description="{{report}}") Var reportName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{path}}") Var path) throws Exception {
        return Operations.generateReport(reportName, path, Var.VAR_NULL, Var.VAR_NULL, true);
    }

    @CronapiMetaData(type="function", name="{{generateReportWithParam}}", nameTags={"generateReport", "GerarRelatorio"}, description="{{generateReportDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var generateReportWithParam(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{report}}") Var reportName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{type}}", blockType="util_dropdown", keys={"pdf", "html", "excel"}, values={"PDF", "HTML", "EXCEL"}) Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{path}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{params}}") Var params) throws Exception {
        return Operations.generateReport(reportName, path, params, type, false);
    }

    @CronapiMetaData(type="function", name="{{generateReportWithJsonContent}}", nameTags={"generateReport", "GerarRelatorio"}, description="{{generateReportDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var generateReportWithJsonContent(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{reportContent}}") Var reportContent, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{type}}", blockType="util_dropdown", keys={"pdf", "html", "excel"}, values={"PDF", "HTML", "EXCEL"}) Var type, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{path}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{params}}") Var params) throws Exception {
        return Operations.generateStimulsoftReport(reportContent, path, params, type);
    }

    private static Map normalizeParameters(Var params) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (params.getType() == Var.Type.LIST) {
            for (Object param : params.getObjectAsList()) {
                if (Var.valueOf(param).isEmptyOrNull().booleanValue()) continue;
                parameters.put(Var.valueOf(param).getId(), Var.valueOf(param).getObjectAsString());
            }
        } else {
            Iterator iterator = params.getObjectAsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry m = entry = iterator.next();
                parameters.put((String)m.getKey(), ((Var)m.getValue()).getObjectAsString());
            }
        }
        return parameters;
    }

    private static final Var generateStimulsoftReport(Var reportContent, Var path, Var params, Var type) throws Exception {
        if (!reportContent.isEmptyOrNull().booleanValue() && !path.isEmptyOrNull().booleanValue()) {
            String formatType = Boolean.TRUE.equals(type.isEmptyOrNull()) ? TYPE_PDF : type.getObjectAsString();
            File file = new File(path.getObjectAsString());
            ReportService service = new ReportService();
            service.exportStimulsoftReportContentToFile(reportContent.getObjectAsString(), file, Operations.normalizeParameters(params), formatType, false);
            return Var.valueOf(file);
        }
        throw new RuntimeException("Error without parameters/content");
    }

    public static final Var generateReport(Var reportName, Var path, Var params) {
        return Operations.generateReport(reportName, path, params, new Var(TYPE_PDF), false);
    }

    private static final Var generateReport(Var reportName, Var path, Var params, Var type, Boolean legacy) {
        File file;
        if (!reportName.isNull().booleanValue() || !path.isNull().booleanValue()) {
            ReportService service = new ReportService();
            file = new File(path.getObjectAsString());
            Map parameters = Operations.normalizeParameters(params);
            if (legacy.booleanValue()) {
                service.exportStimulsoftReportToPdfFile(reportName.getObjectAsString(), file, parameters);
            } else {
                service.exportStimulsoftReportToFile(reportName.getObjectAsString(), file, (Map<String, String>)parameters, type.getObjectAsString(), (Boolean)false);
            }
        } else {
            throw new RuntimeException("Error without parameters");
        }
        return Var.valueOf(file);
    }
}

