window.onload = function() {
  const TOKEN_HEADER_NAME  = 'X-CSRF-TOKEN';   // <‑‑ adapt to your API
  const LS_KEY             = 'csrfToken';

  /** read token from localStorage, or (fallback) from the XSRF‑TOKEN cookie */
  function readToken() {
    let t = localStorage.getItem(LS_KEY);
    if (!t) {
      const m = document.cookie.match(/(?:^|;\s*)XSRF-TOKEN=([^;]+)/);
      if (m) t = decodeURIComponent(m[1]);
    }
    return t;
  }

  /** persist the latest token if the server sent one in the response headers */
  function persistToken(res) {
    // Swagger 3 gives you a plain Fetch Response object here
    const newToken = res.headers.get(TOKEN_HEADER_NAME);
    if (newToken) {
      localStorage.setItem(LS_KEY, newToken);
    }
    return res;
  }

  window.ui = SwaggerUIBundle({
    url: location.pathname.replace('/api/metadata/index.html','/api/metadata/configuration'),
    dom_id: '#swagger-ui',
    deepLinking: true,
    presets: [
      SwaggerUIBundle.presets.apis,
      SwaggerUIStandalonePreset
    ],
    plugins: [
      SwaggerUIBundle.plugins.DownloadUrl,
      HideTopbarPlugin
    ],
    layout: "StandaloneLayout",
    requestInterceptor: function(request) {
      // Get CSRF token from localStorage (consistent with other implementations)
      const csrfToken = localStorage.getItem('csrfToken');
      if (csrfToken) {
        request.headers['X-CSRF-TOKEN'] = csrfToken;
      }
      return request;
    },
    responseInterceptor: function(response) {
      // Check for new CSRF token in responses
      const newToken = response.headers['X-CSRF-TOKEN'];
      if (newToken) {
        localStorage.setItem('csrfToken', newToken);
      }
      return response;
    }
  });

  function HideTopbarPlugin() {
    // this plugin overrides the Topbar component to return nothing
    return {
      components: {
        Topbar: function() { return null; }
      }
    };
  }
};
