/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.authentication.external.ActiveDirectoryAuthenticator;
import cronapp.framework.authentication.external.ExternalAuthenticator;
import cronapp.framework.authentication.external.LdapAuthenticator;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ExternalAuthenticationConfig {
    private static String type;
    private static final String INTERNAL = "internal";
    private static final String FACEBOOK = "facebook";
    private static final String LINKEDIN = "linkedin";
    private static final String CRONAPP = "cronapp";
    private static final String GOOGLE = "google";
    private static final String GITHUB = "github";
    private static final String TOKEN = "Token";
    private static final String NORMAL = "Normal";
    private static final String ACTIVE_DIRECTORY = "activeDirectory";
    private static final String LDAP = "ldap";
    private static final String SAML = "Saml";
    private static final String SSO = "SSO";
    private static Set<String> SOCIAL;

    public static String getExternalAuthType() {
        return type;
    }

    public static boolean isExternalAuth() {
        return !INTERNAL.equalsIgnoreCase(type) && !TOKEN.equalsIgnoreCase(type) && !NORMAL.equalsIgnoreCase(type) && !SAML.equalsIgnoreCase(type) && !SSO.equalsIgnoreCase(type);
    }

    public static boolean isSocial(String provider) {
        return SOCIAL.contains(provider.toLowerCase());
    }

    public static Authentication authenticateExternally(Authentication authentication) throws AuthenticationException {
        return ExternalAuthenticationConfig.authenticator(type).authenticate(authentication);
    }

    private static ExternalAuthenticator authenticator(String type) {
        if (ACTIVE_DIRECTORY.equalsIgnoreCase(type)) {
            return new ActiveDirectoryAuthenticator();
        }
        if (LDAP.equalsIgnoreCase(type)) {
            return new LdapAuthenticator();
        }
        throw new ProviderNotFoundException(String.format("No AuthenticationProvider found for %s", type));
    }

    static {
        SOCIAL = new HashSet<String>();
        type = AppConfig.type();
        SOCIAL.add(FACEBOOK);
        SOCIAL.add(LINKEDIN);
        SOCIAL.add(CRONAPP);
        SOCIAL.add(GOOGLE);
        SOCIAL.add(GITHUB);
    }
}

