/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;

public class CronappApplication {
    public static void run(String[] args) throws Exception {
        Path webappPath = Paths.get("src/main/webapp/", new String[0]);
        Path mobilePath = Paths.get("src/main/mobileapp/www/", new String[0]);
        Tomcat tomcat = new Tomcat();
        String port = System.getenv("PORT");
        if (port == null || port.isEmpty()) {
            port = "8000";
        }
        File baseDir = Files.createTempDirectory("cronapp", new FileAttribute[0]).toFile();
        baseDir.mkdirs();
        tomcat.setPort(Integer.valueOf(port).intValue());
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        tomcat.enableNaming();
        tomcat.getConnector();
        if (mobilePath.toFile().exists()) {
            StandardContext mobileContext = (StandardContext)tomcat.addWebapp("", mobilePath.toAbsolutePath().toString());
            mobileContext.setDefaultContextXml(Paths.get("config/context.xml", new String[0]).toAbsolutePath().toString());
            if (webappPath.toFile().exists()) {
                StandardContext webContext = (StandardContext)tomcat.addWebapp("webapp", webappPath.toAbsolutePath().toString());
                webContext.setDefaultContextXml(Paths.get("config/context.xml", new String[0]).toAbsolutePath().toString());
            }
        } else if (webappPath.toFile().exists()) {
            StandardContext webContext = (StandardContext)tomcat.addWebapp("", webappPath.toAbsolutePath().toString());
            webContext.setDefaultContextXml(Paths.get("config/context.xml", new String[0]).toAbsolutePath().toString());
        } else {
            File docBase = Files.createTempDirectory("cronapp", new FileAttribute[0]).toFile();
            docBase.mkdirs();
            tomcat.addWebapp("", docBase.getAbsolutePath());
        }
        tomcat.start();
        tomcat.getServer().await();
    }
}

