/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.boot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.xml.sax.SAXException;

public class CronappWebServerFactory
extends TomcatServletWebServerFactory {
    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        tomcat.enableNaming();
        return super.getTomcatWebServer(tomcat);
    }

    protected void postProcessContext(Context context) {
        block8: {
            super.postProcessContext(context);
            try {
                URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/META-INF/context.xml");
                if (resourceUrl == null) break block8;
                Digester contextDigester = this.createContextDigester();
                contextDigester.getParser();
                contextDigester.setClassLoader(ContextConfig.class.getClassLoader());
                contextDigester.setUseContextClassLoader(false);
                contextDigester.push((Object)context.getParent());
                contextDigester.push((Object)context);
                try (InputStream resourceInputStream = resourceUrl.openStream();){
                    contextDigester.parse(resourceInputStream);
                }
            }
            catch (IOException | SAXException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet((RuleSet)contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet((RuleSet)namingRuleSet);
        return digester;
    }

    protected void customizeConnector(Connector connector) {
        super.customizeConnector(connector);
        String port = System.getenv("PORT");
        if (port == null || port.isEmpty()) {
            port = "8000";
        }
        connector.setPort(Integer.parseInt(port));
    }
}

