/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.sso;

import com.google.gson.Gson;
import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.sso.CustomPrincipalExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CustomAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CustomAuthoritiesExtractor.class);
    private static final String CLAIM_AUTHORITIES = "https://www.cronapp.io/authorities";
    private static final String[] AUTHORITY_KEYS = new String[]{"authority", "role", "value"};
    private PrincipalExtractor principalExtractor;

    public static void main(String[] args) {
        HashMap<String, Object> rawAuthorities = new HashMap<String, Object>();
        rawAuthorities.put("sub", "9202d3da-0403-44c5-b947-aed909b0b41c");
        rawAuthorities.put("email_verified", false);
        rawAuthorities.put("name", "Teste Teste");
        rawAuthorities.put("preferred_username", "teste");
        rawAuthorities.put("given_name", "Teste");
        rawAuthorities.put("family_name", "Teste");
        new CustomAuthoritiesExtractor(new CustomPrincipalExtractor()).extractAuthorities(rawAuthorities);
    }

    CustomAuthoritiesExtractor(PrincipalExtractor principalExtractor) {
        this.principalExtractor = principalExtractor;
    }

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        logger.info("Extracting authorities from values: " + new Gson().toJson(map));
        String authorities = "ROLE_USER";
        if (map.containsKey(CLAIM_AUTHORITIES)) {
            authorities = this.asAuthorities(map.get(CLAIM_AUTHORITIES));
        }
        List grantedAuthorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
        String userName = (String)this.principalExtractor.extractPrincipal(map);
        return this.getMappedAuthorities(userName, grantedAuthorities);
    }

    private String asAuthorities(Object object) {
        ArrayList<Object> authorities = new ArrayList<Object>();
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            object = collection.toArray(new Object[0]);
        }
        if (ObjectUtils.isArray((Object)object)) {
            Object[] array;
            for (Object value : array = (Object[])object) {
                if (value instanceof String) {
                    authorities.add(value);
                    continue;
                }
                if (value instanceof Map) {
                    authorities.add(this.asAuthority((Map)value));
                    continue;
                }
                authorities.add(value);
            }
            return StringUtils.collectionToCommaDelimitedString(authorities);
        }
        return object.toString();
    }

    private Object asAuthority(Map<?, ?> map) {
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        for (String key : AUTHORITY_KEYS) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return map;
    }

    private List<GrantedAuthority> getMappedAuthorities(String userName, List<GrantedAuthority> grantedAuthorities) {
        Set securables = grantedAuthorities.stream().flatMap(authority -> ApiManager.getRoleSecurables(authority.getAuthority()).stream()).map(securable -> securable.getStringField("name")).collect(Collectors.toSet());
        securables.addAll(ApiManager.getUserSecurables(userName).stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        securables.addAll(ApiManager.getAuthenticatedSecurables().stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        securables.addAll(ApiManager.getPublicSecurables().stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        return securables.stream().distinct().sorted().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}

