/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token;

import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.TokenUtils;
import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import cronapi.database.HistoryListener;
import cronapi.database.TransactionManager;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.AuthenticationUtil;
import cronapp.framework.authentication.security.CronappAnonymousAuthenticationFilter;
import cronapp.framework.authentication.security.Permission;
import cronapp.framework.authentication.token.AuthenticationTokenFilter;
import cronapp.framework.authentication.token.EntryPointUnauthorizedHandler;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.Cookie;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired(required=false)
    private Permission permission;
    @Autowired
    private EntryPointUnauthorizedHandler unauthorizedHandler;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private List<AccessDecisionVoter<? extends Object>> decisionVoters;
    @Value(value="${cronapp.security.authentication:true}")
    private boolean authentication;

    @Autowired
    public void configureAuthentication(AuthenticationManagerBuilder authenticationManagerBuilder) throws Exception {
        authenticationManagerBuilder.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationTokenFilter authenticationTokenFilterBean() throws Exception {
        AuthenticationTokenFilter authenticationTokenFilter = new AuthenticationTokenFilter(this.authentication);
        authenticationTokenFilter.setAuthenticationManager(super.authenticationManagerBean());
        return authenticationTokenFilter;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    private LogoutSuccessHandler logoutHandler() {
        return (request, response, authentication) -> {
            String username;
            String authToken = request.getHeader("X-AUTH-TOKEN");
            if (authToken == null || authToken.isBlank()) {
                authToken = TokenUtils.getTokenFromCookie((Cookie[])request.getCookies());
            }
            if ((username = TokenUtils.getUsernameFromToken((String)authToken)) != null && SecurityContextHolder.getContext().getAuthentication() == null && TokenUtils.getScopeFromToken((String)authToken).isEmpty() && !TokenUtils.isTokenExpired((String)authToken)) {
                TokenUtils.revokeToken((String)authToken);
                this.doLogAuthOperation(username);
                if (EventsManager.hasEvent("onLogout")) {
                    EventsManager.executeEventOnTransaction("onLogout", Var.valueOf((String)"username", (Object)username));
                }
            }
            for (Cookie cookie : request.getCookies()) {
                if (!"AuthToken".equals(cookie.getName())) continue;
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
            if (request.getHeader("Accept") == null || !request.getHeader("Accept").contains("json")) {
                response.setStatus(200);
                response.sendRedirect("/index.html");
            }
        };
    }

    private void doLogAuthOperation(String user) {
        try {
            DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
            if (logManager != null) {
                String className = logManager.getEntity();
                Class<?> c = Class.forName(className);
                TransactionManager.begin(c);
                JsonObject json = new JsonObject();
                JsonArray arrayParams = new JsonArray();
                json.add("parameters", (JsonValue)arrayParams);
                Var auditLog = new Var(new LinkedHashMap());
                auditLog.set("type", (Object)"app.authorization.Logout");
                auditLog.set("command", (Object)"logout");
                auditLog.set("category", (Object)"Authorization");
                auditLog.set("date", (Object)new Date());
                auditLog.set("objectData", (Object)json.toString());
                if (RestClient.getRestClient() != null) {
                    auditLog.set("user", (Object)user);
                    auditLog.set("host", (Object)RestClient.getRestClient().getHost());
                    auditLog.set("agent", (Object)RestClient.getRestClient().getAgent());
                }
                auditLog.set("server", (Object)HistoryListener.CURRENT_IP);
                auditLog.set("affectedFields", null);
                auditLog.set("application", (Object)AppConfig.guid());
                logManager.insert((Object)auditLog, new Object[0]);
                TransactionManager.commit(c);
            }
        }
        catch (Exception e) {
            System.out.print("Error on logging: " + e.getMessage());
        }
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)httpSecurity.csrf().disable()).headers().cacheControl().disable().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler).and()).logout().logoutSuccessHandler(this.logoutHandler()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        if (this.permission != null) {
            AuthenticationUtil.loadStaticSecurity(httpSecurity);
            this.permission.loadSecurityPermission(httpSecurity);
        } else {
            List<GrantedAuthority> publicAuthorities = this.authentication ? ApiManager.getPublicAuthorities() : List.of(new SimpleGrantedAuthority("Public"));
            httpSecurity.anonymous().authenticationFilter((AnonymousAuthenticationFilter)new CronappAnonymousAuthenticationFilter("anonymousAuthenticationFilterKey", "anonymousUser", publicAuthorities));
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)httpSecurity.authorizeRequests().anyRequest()).denyAll().accessDecisionManager((AccessDecisionManager)new UnanimousBased(this.decisionVoters));
        }
        httpSecurity.headers().cacheControl().disable().xssProtection().block(false).and().contentTypeOptions().and().httpStrictTransportSecurity().disable();
        if (AppConfig.xFrameOptions().equals("SameOrigin")) {
            httpSecurity.headers().frameOptions().sameOrigin();
        } else if (AppConfig.xFrameOptions().equals("Deny")) {
            httpSecurity.headers().frameOptions().deny();
        } else {
            httpSecurity.headers().frameOptions().disable();
        }
        httpSecurity.addFilterBefore((Filter)this.authenticationTokenFilterBean(), UsernamePasswordAuthenticationFilter.class);
    }
}

