/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.security;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.TokenUtils;
import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.authentication.security.CronappUserDetails;
import cronapp.framework.i18n.Messages;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class CronappAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.clearAuthenticationAttributes(request);
        String userName = authentication.getName();
        ApiManager apiManager = ApiManager.byUserAndPassword(userName, null, "saml", true, null);
        try {
            User user = apiManager.getUser((CronappUserDetails)authentication.getDetails());
            boolean root = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(authority -> StringUtils.equals((CharSequence)authority, (CharSequence)"Administratros"));
            String roles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
            Gson gson = new Gson();
            JsonObject json = new JsonObject();
            json.add("user", gson.toJsonTree((Object)user.resetPassword()));
            json.add("picture", gson.toJsonTree((Object)user.getPicture()));
            json.addProperty("roles", roles);
            json.addProperty("theme", "");
            json.addProperty("root", Boolean.valueOf(root));
            if (EventsManager.hasEvent("onLogin")) {
                EventsManager.executeEventOnTransaction("onLogin", Var.valueOf((String)"username", (Object)authentication.getName()));
            }
            LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
            String token = TokenUtils.generateToken((UserDetails)((UserDetails)authentication.getDetails()), (String)user.getName(), (Device)deviceResolver.resolveDevice(request), (String)"saml");
            response.setStatus(200);
            this.getRedirectStrategy().sendRedirect(request, response, "/#/connected?_ctk=" + token);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
        }
    }
}

