/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.social;

import br.com.techne.cronapp.acesso.AcessoService;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.CronapiConfigurator;
import cronapi.ErrorResponse;
import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.authentication.social.SocialConfig;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import java.net.URLEncoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/signin/cronapp"})
public class CronappSign {
    public static final String HTTPS_ACESSO_CRONAPP_IO = "https://acesso.cronapp.io";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired(required=false)
    private AuthenticationConfigurer authenticationConfigurer;
    @Autowired(required=false)
    private AuthenticationController authenticationController;

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.GET})
    public void get(@RequestParam(name="_ctk") String ctk) throws Exception {
        if (!SocialConfig.isEnabled("cronapp")) {
            throw new Exception(Messages.getString("notAllowed"));
        }
        AcessoService acesso = new AcessoService(HTTPS_ACESSO_CRONAPP_IO, "", "");
        acesso.validaToken(ctk);
        String json = acesso.getUserInfo(ctk);
        Gson gson = new Gson();
        JsonElement elem = (JsonElement)gson.fromJson(json, JsonElement.class);
        String email = elem.getAsJsonObject().get("email").getAsString();
        String name = elem.getAsJsonObject().get("given_name").getAsString();
        String lastname = elem.getAsJsonObject().get("family_name").getAsString();
        JsonObject details = new JsonObject();
        details.addProperty("name", (name + " " + lastname).trim());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)email, (Object)"cronapp", Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));
        auth.setDetails((Object)details);
        String redirect = this.request.getContextPath() + "/#/connected";
        if (this.authenticationConfigurer != null) {
            Authentication socialAuth = this.authenticationConfigurer.authenticate((Authentication)auth);
            SecurityContextHolder.getContext().setAuthentication(socialAuth);
            try {
                this.request.getSession().setAttribute("#OAUTH#USER", (Object)email);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
            ResponseEntity<AuthenticationResponse> authenticationRequest = this.authenticationController.auth(email, "cronapp", deviceResolver.resolveDevice(this.request), "cronapp", null, details, this.request, this.response);
            redirect = this.request.getContextPath() + "/#/connected?_ctk=" + ((AuthenticationResponse)authenticationRequest.getBody()).getToken();
        }
        this.response.sendRedirect(redirect);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public void post() throws Exception {
        if (!SocialConfig.isEnabled("cronapp")) {
            throw new Exception(Messages.getString("notAllowed"));
        }
        this.response.sendRedirect("https://acesso.cronapp.io/#/?redirect_url=" + URLEncoder.encode(this.request.getRequestURL().toString(), CronapiConfigurator.ENCODING));
    }
}

