/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token.google;

import cronapi.AppConfig;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.User;
import cronapp.framework.authentication.token.google.GoogleResponse;
import cronapp.framework.authentication.token.google.ICaptchaVerify;
import cronapp.framework.authentication.token.google.ReCaptchaInvalidException;
import cronapp.framework.i18n.Messages;
import java.net.URI;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class CaptchaVerify
implements ICaptchaVerify {
    private static final Logger log = LoggerFactory.getLogger(CaptchaVerify.class);
    private static final String RECAPTCHA_TOKEN = "recaptchaToken";
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("[A-Za-z0-9_-]+");
    private static final String URL_VERIFY = "https://www.google.com/recaptcha/api/siteverify?secret=%s&response=%s";
    private static String secretVerify = AppConfig.tokenRecaptcha();
    private static boolean userRecaptchaBackEnd = StringUtils.hasText((String)secretVerify);
    private RestOperations restTemplate = new RestTemplate();

    @Override
    public boolean processRequest(String username, HttpServletRequest request) throws Exception {
        if (!userRecaptchaBackEnd) {
            return true;
        }
        Assert.isTrue((boolean)request.getParameterMap().containsKey(RECAPTCHA_TOKEN), (String)Messages.getString("TokenRecaptcha"));
        Assert.hasText((String)request.getParameter(RECAPTCHA_TOKEN), (String)Messages.getString("TokenEmptyRecaptcha"));
        User user = ApiManager.byUser(username).getUser();
        this.verifyToken(user, request.getParameter(RECAPTCHA_TOKEN));
        URI verifyUri = URI.create(String.format(this.getUrl(), this.getCaptchaSecret(), request.getParameter(RECAPTCHA_TOKEN)));
        try {
            GoogleResponse googleResponse = (GoogleResponse)this.restTemplate.getForObject(verifyUri, GoogleResponse.class);
            if (Objects.nonNull(googleResponse)) {
                String value = googleResponse.toString();
                log.debug("Google's response: {} ", (Object)value);
                if (!googleResponse.isSuccess()) {
                    throw new AuthenticationServiceException(Messages.getString("TokenValidatedRecaptcha"));
                }
            }
        }
        catch (RestClientException rce) {
            throw new AuthenticationServiceException(Messages.getString("TokenRegistrationRecaptcha"), (Throwable)rce);
        }
        return true;
    }

    private void verifyToken(User user, String token) throws Exception {
        if (!this.responseSanityCheck(token)) {
            throw new ReCaptchaInvalidException(Messages.getString("RecaptchaInvalidCaracters"));
        }
    }

    private boolean responseSanityCheck(String response) {
        return StringUtils.hasLength((String)response) && RESPONSE_PATTERN.matcher(response).matches();
    }

    @Override
    public String getCaptchaSecret() {
        return new String(Base64.getDecoder().decode(secretVerify)).trim();
    }

    @Override
    public String getUrl() {
        return URL_VERIFY;
    }
}

