/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ClientChannelFactory;
import io.deephaven.client.impl.ClientConfig;
import io.deephaven.client.impl.ImmutableClientChannelFactoryDefaulter;
import io.deephaven.ssl.config.SSLConfig;
import io.grpc.ManagedChannel;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class ClientChannelFactoryDefaulter
implements ClientChannelFactory {
    public static Builder builder() {
        return ImmutableClientChannelFactoryDefaulter.builder();
    }

    @Value.Default
    public ClientChannelFactory delegate() {
        return ClientChannelFactory.defaultInstance();
    }

    public abstract Optional<SSLConfig> ssl();

    public abstract Optional<String> userAgent();

    @Override
    public final ManagedChannel create(ClientConfig config) {
        if (this.ssl().isPresent() && !config.ssl().isPresent() && config.target().isSecure()) {
            config = config.withSsl(this.ssl().get());
        }
        if (this.userAgent().isPresent() && !config.userAgent().isPresent()) {
            config = config.withUserAgent(this.userAgent().get());
        }
        return this.delegate().create(config);
    }

    public static interface Builder {
        public Builder delegate(ClientChannelFactory var1);

        public Builder ssl(SSLConfig var1);

        public Builder userAgent(String var1);

        public ClientChannelFactoryDefaulter build();
    }
}

