/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.CopyableStyle;
import io.deephaven.client.impl.ImmutableClientConfig;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.uri.DeephavenTarget;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@CopyableStyle
public abstract class ClientConfig {
    public static final int DEFAULT_MAX_INBOUND_MESSAGE_SIZE = 0x6400000;

    public static Builder builder() {
        return ImmutableClientConfig.builder();
    }

    public abstract DeephavenTarget target();

    public abstract Optional<SSLConfig> ssl();

    public abstract Optional<String> userAgent();

    public abstract Optional<String> overrideAuthority();

    public abstract Map<String, String> extraHeaders();

    @Value.Default
    public int maxInboundMessageSize() {
        return 0x6400000;
    }

    public abstract ClientConfig withSsl(SSLConfig var1);

    public abstract ClientConfig withUserAgent(String var1);

    public static interface Builder {
        public Builder target(DeephavenTarget var1);

        public Builder ssl(SSLConfig var1);

        public Builder userAgent(String var1);

        public Builder overrideAuthority(String var1);

        public Builder putExtraHeaders(String var1, String var2);

        public Builder putAllExtraHeaders(Map<String, ? extends String> var1);

        public Builder maxInboundMessageSize(int var1);

        public ClientConfig build();
    }
}

