/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.protobuf.ByteString;
import io.deephaven.client.impl.ServerObject;
import io.deephaven.client.impl.Session;
import io.deephaven.client.impl.TypedTicket;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class ServerData
implements Closeable {
    private final ByteString data;
    private final List<ServerObject> exports;

    static ServerData of(Session session, io.deephaven.proto.backplane.grpc.ServerData data) {
        return new ServerData(data.getPayload(), ServerData.toServerObjects(session, data.getExportedReferencesList()));
    }

    private static List<ServerObject> toServerObjects(Session session, List<io.deephaven.proto.backplane.grpc.TypedTicket> exportTickets) {
        return exportTickets.stream().map(TypedTicket::from).map(TypedTicket::toExportId).map(exportId -> exportId.toServerObject(session)).collect(Collectors.toList());
    }

    private ServerData(ByteString data, List<ServerObject> exports) {
        this.data = Objects.requireNonNull(data);
        this.exports = Collections.unmodifiableList(exports);
    }

    public ByteBuffer data() {
        return this.data.asReadOnlyByteBuffer();
    }

    public List<ServerObject> exports() {
        return this.exports;
    }

    public CompletableFuture<Void> releaseExports() {
        return CompletableFuture.allOf((CompletableFuture[])this.exports.stream().map(ServerObject::release).toArray(CompletableFuture[]::new));
    }

    @Override
    public void close() {
        for (ServerObject export : this.exports) {
            export.close();
        }
    }
}

