/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.client.impl.ImmutableSessionConfig;
import io.deephaven.client.impl.SessionConfigHelper;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class SessionConfig {
    public static Builder builder() {
        return ImmutableSessionConfig.builder();
    }

    @Value.Redacted
    public abstract Optional<String> authenticationTypeAndValue();

    public abstract Optional<ScheduledExecutorService> scheduler();

    @Value.Default
    public boolean delegateToBatch() {
        return SessionConfigHelper.delegateToBatch();
    }

    @Value.Default
    public boolean mixinStacktrace() {
        return SessionConfigHelper.mixinStacktrace();
    }

    @Value.Default
    public Duration executeTimeout() {
        return SessionConfigHelper.executeTimeout();
    }

    @Value.Default
    public Duration closeTimeout() {
        return SessionConfigHelper.closeTimeout();
    }

    public static interface Builder {
        public Builder authenticationTypeAndValue(String var1);

        public Builder scheduler(ScheduledExecutorService var1);

        public Builder delegateToBatch(boolean var1);

        public Builder mixinStacktrace(boolean var1);

        public Builder executeTimeout(Duration var1);

        public Builder closeTimeout(Duration var1);

        public SessionConfig build();
    }
}

