/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.TableHandle;
import io.deephaven.client.impl.TableHandleManager;
import io.deephaven.qst.LabeledValues;
import io.deephaven.qst.table.EmptyTable;
import io.deephaven.qst.table.InputTable;
import io.deephaven.qst.table.LabeledTables;
import io.deephaven.qst.table.MergeTable;
import io.deephaven.qst.table.MultiJoinInput;
import io.deephaven.qst.table.MultiJoinTable;
import io.deephaven.qst.table.NewTable;
import io.deephaven.qst.table.TableSpec;
import io.deephaven.qst.table.TicketTable;
import io.deephaven.qst.table.TimeTable;
import java.util.List;

abstract class TableHandleManagerBase
implements TableHandleManager {
    TableHandleManagerBase() {
    }

    protected abstract TableHandle handle(TableSpec var1);

    @Override
    public final LabeledValues<TableHandle> execute(LabeledTables tables) throws TableHandle.TableHandleException, InterruptedException {
        return LabeledValues.of((Iterable)tables.labels(), this.execute(tables.values()));
    }

    public final TableHandle of(NewTable newTable) {
        return this.handle((TableSpec)newTable);
    }

    public final TableHandle of(EmptyTable emptyTable) {
        return this.handle((TableSpec)emptyTable);
    }

    public final TableHandle of(TimeTable timeTable) {
        return this.handle((TableSpec)timeTable);
    }

    public final TableHandle of(TicketTable ticketTable) {
        return this.handle((TableSpec)ticketTable);
    }

    public final TableHandle of(InputTable inputTable) {
        return this.handle((TableSpec)inputTable);
    }

    public final TableHandle multiJoin(List<MultiJoinInput<TableHandle>> multiJoinInputs) {
        MultiJoinTable.Builder builder = MultiJoinTable.builder();
        for (MultiJoinInput<TableHandle> input : multiJoinInputs) {
            builder.addInputs(MultiJoinInput.builder().table((Object)((TableHandle)input.table()).table()).addAllMatches((Iterable)input.matches()).addAllAdditions((Iterable)input.additions()).build());
        }
        return this.handle((TableSpec)builder.build());
    }

    public final TableHandle merge(Iterable<TableHandle> tableProxies) {
        MergeTable.Builder builder = MergeTable.builder();
        for (TableHandle tableProxy : tableProxies) {
            builder.addTables(tableProxy.table());
        }
        return this.handle((TableSpec)builder.build());
    }
}

