/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.api.TableOperations;
import io.deephaven.client.impl.ExportService;
import io.deephaven.client.impl.TableHandle;
import io.deephaven.client.impl.TableHandleManagerBase;
import io.deephaven.client.impl.TableServiceImpl;
import io.deephaven.qst.LabeledValues;
import io.deephaven.qst.TableAdapterResults;
import io.deephaven.qst.TableCreationLabeledLogic;
import io.deephaven.qst.TableCreationLogic;
import io.deephaven.qst.TableCreationLogic1Input;
import io.deephaven.qst.TableCreationLogic2Inputs;
import io.deephaven.qst.TableCreator;
import io.deephaven.qst.table.TableSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class TableHandleManagerSerial
extends TableHandleManagerBase {
    TableHandleManagerSerial() {
    }

    protected abstract ExportService exportService();

    @Override
    public TableHandle execute(TableSpec table) throws TableHandle.TableHandleException, InterruptedException {
        TableAdapterResults results;
        ExportService exportService = this.exportService();
        Tracker tracker = new Tracker();
        TableHandleManagerSerial manager = TableHandleManagerSerial.inner(exportService, tracker);
        try {
            results = TableHandleManagerSerial.checked(() -> TableCreator.create((TableCreator)manager, i -> i, i -> i, (TableSpec)table));
        }
        catch (Throwable t) {
            tracker.closeAllExceptAndRemoveAll(Collections.emptySet());
            throw t;
        }
        TableHandle out = (TableHandle)((TableAdapterResults.Output)results.map().get(table)).walk((TableAdapterResults.Output.Visitor)new TableAdapterResults.GetOutput());
        tracker.closeAllExceptAndRemoveAll(Collections.singleton(out));
        return out;
    }

    @Override
    public List<TableHandle> execute(Iterable<TableSpec> tables) throws TableHandle.TableHandleException, InterruptedException {
        TableAdapterResults results;
        ExportService exportService = this.exportService();
        Tracker tracker = new Tracker();
        TableHandleManagerSerial manager = TableHandleManagerSerial.inner(exportService, tracker);
        try {
            results = TableHandleManagerSerial.checked(() -> TableCreator.create((TableCreator)manager, i -> i, i -> i, (Iterable)tables));
        }
        catch (Throwable t) {
            tracker.closeAllExceptAndRemoveAll(Collections.emptySet());
            throw t;
        }
        ArrayList<TableHandle> newRefs = new ArrayList<TableHandle>();
        for (TableSpec table : tables) {
            TableHandle handle = (TableHandle)((TableAdapterResults.Output)results.map().get(table)).walk((TableAdapterResults.Output.Visitor)new TableAdapterResults.GetOutput());
            newRefs.add(handle.newRef());
        }
        tracker.closeAllExceptAndRemoveAll(new HashSet<TableHandle>(newRefs));
        return newRefs;
    }

    @Override
    public TableHandle executeLogic(TableCreationLogic logic) throws TableHandle.TableHandleException, InterruptedException {
        TableHandle out;
        ExportService exportService = this.exportService();
        Tracker tracker = new Tracker();
        TableHandleManagerSerial manager = TableHandleManagerSerial.inner(exportService, tracker);
        try {
            out = TableHandleManagerSerial.checked(() -> (TableHandle)logic.create((TableCreator)manager));
        }
        catch (Throwable t) {
            tracker.closeAllExceptAndRemoveAll(Collections.emptySet());
            throw t;
        }
        tracker.closeAllExceptAndRemoveAll(Collections.singleton(out));
        return out;
    }

    @Override
    public List<TableHandle> executeLogic(Iterable<TableCreationLogic> logics) throws TableHandle.TableHandleException, InterruptedException {
        ExportService exportService = this.exportService();
        Tracker tracker = new Tracker();
        TableHandleManagerSerial manager = TableHandleManagerSerial.inner(exportService, tracker);
        ArrayList<TableHandle> out = new ArrayList<TableHandle>();
        try {
            for (TableCreationLogic logic : logics) {
                out.add(TableHandleManagerSerial.checked(() -> (TableHandle)logic.create((TableCreator)manager)));
            }
        }
        catch (Throwable t) {
            tracker.closeAllExceptAndRemoveAll(Collections.emptySet());
            throw t;
        }
        tracker.closeAllExceptAndRemoveAll(new HashSet<TableHandle>(out));
        return out;
    }

    @Override
    public LabeledValues<TableHandle> executeLogic(TableCreationLabeledLogic logic) throws TableHandle.TableHandleException, InterruptedException {
        LabeledValues out;
        ExportService exportService = this.exportService();
        Tracker tracker = new Tracker();
        TableHandleManagerSerial manager = TableHandleManagerSerial.inner(exportService, tracker);
        try {
            out = TableHandleManagerSerial.checked(() -> logic.create((TableCreator)manager));
        }
        catch (Throwable t) {
            tracker.closeAllExceptAndRemoveAll(Collections.emptySet());
            throw t;
        }
        tracker.closeAllExceptAndRemoveAll(out.valueSet());
        return out;
    }

    @Override
    public TableHandle executeInputs(TableCreationLogic1Input logic, TableHandle t1) throws TableHandle.TableHandleException, InterruptedException {
        return TableHandleManagerSerial.checked(() -> (TableHandle)logic.create((TableOperations)t1));
    }

    @Override
    public TableHandle executeInputs(TableCreationLogic2Inputs logic, TableHandle t1, TableHandle t2) throws InterruptedException, TableHandle.TableHandleException {
        return TableHandleManagerSerial.checked(() -> (TableHandle)logic.create((TableOperations)t1, (TableOperations)t2));
    }

    private static <T> T checked(Unchecked<T> uncheckedCode) throws InterruptedException, TableHandle.TableHandleException {
        try {
            return uncheckedCode.run();
        }
        catch (TableHandle.UncheckedInterruptedException e) {
            throw e.getCause();
        }
        catch (TableHandle.UncheckedTableHandleException e) {
            throw e.getCause();
        }
    }

    private static TableHandleManagerSerial inner(final ExportService exportService, final Tracker tracker) {
        return new TableHandleManagerSerial(){

            @Override
            protected ExportService exportService() {
                return exportService;
            }

            @Override
            protected TableHandle handle(TableSpec table) {
                return TableServiceImpl.executeUnchecked(exportService, table, tracker);
            }
        };
    }

    private static class Tracker
    implements TableServiceImpl.Lifecycle {
        private Set<TableHandle> handles = new LinkedHashSet<TableHandle>();

        private Tracker() {
        }

        @Override
        public synchronized void onInit(TableHandle handle) {
            if (this.handles == null) {
                return;
            }
            this.handles.add(handle);
        }

        @Override
        public synchronized void onRelease(TableHandle handle) {
            if (this.handles == null) {
                return;
            }
            this.handles.remove(handle);
        }

        public synchronized void closeAllExceptAndRemoveAll(Set<TableHandle> exceptions) {
            Iterator<TableHandle> it = this.handles.iterator();
            while (it.hasNext()) {
                TableHandle handle = it.next();
                it.remove();
                if (exceptions.contains(handle)) continue;
                handle.close(true);
            }
            this.handles = null;
        }
    }

    static interface Unchecked<T> {
        public T run();
    }
}

