/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import com.google.protobuf.ByteStringAccess;
import io.deephaven.client.impl.HasTicketId;
import io.deephaven.client.impl.TypedTicket;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.qst.table.TicketTable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class TicketId
implements HasTicketId {
    private final byte[] ticket;

    static TicketId from(Ticket ticket) {
        return new TicketId(ticket.getTicket().toByteArray());
    }

    public TicketId(byte[] ticket) {
        this.ticket = Objects.requireNonNull(ticket);
    }

    @Override
    public TicketId ticketId() {
        return this;
    }

    public TypedTicket toTypedTicket(String type) {
        return new TypedTicket(type, this);
    }

    public TicketTable table() {
        return TicketTable.of((byte[])this.ticket);
    }

    byte[] bytes() {
        return this.ticket;
    }

    Ticket proto() {
        return Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])this.ticket)).build();
    }

    public String toString() {
        return new String(this.ticket, StandardCharsets.UTF_8);
    }
}

