/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.client.impl.ExportId;
import io.deephaven.client.impl.HasTicketId;
import io.deephaven.client.impl.HasTypedTicket;
import io.deephaven.client.impl.TicketId;
import io.deephaven.proto.backplane.grpc.TypedTicket;
import io.deephaven.proto.util.ExportTicketHelper;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public final class TypedTicket
implements HasTypedTicket {
    private final String type;
    private final TicketId ticket;

    static TypedTicket from(io.deephaven.proto.backplane.grpc.TypedTicket proto) {
        String type = proto.getType();
        TicketId ticket = TicketId.from(proto.getTicket());
        return new TypedTicket(type.isEmpty() ? null : type, ticket);
    }

    public TypedTicket(String type, TicketId ticket) {
        if (type != null && type.isEmpty()) {
            throw new IllegalArgumentException("Must use null instead of empty string to represent no type");
        }
        this.type = type;
        this.ticket = Objects.requireNonNull(ticket);
    }

    public TypedTicket(String type, HasTicketId ticket) {
        this(type, ticket.ticketId());
    }

    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    public TypedTicket typedTicket() {
        return this;
    }

    @Override
    public TicketId ticketId() {
        return this.ticket;
    }

    public String toString() {
        return (String)(this.type == null ? "?:" : this.type + ":") + String.valueOf(this.ticket);
    }

    ExportId toExportId() {
        int exportId = ExportTicketHelper.ticketToExportId((ByteBuffer)ByteBuffer.wrap(this.ticket.bytes()), (String)"exportId");
        return new ExportId(this.type, exportId);
    }

    io.deephaven.proto.backplane.grpc.TypedTicket proto() {
        TypedTicket.Builder builder = io.deephaven.proto.backplane.grpc.TypedTicket.newBuilder().setTicket(this.ticket.proto());
        if (this.type != null) {
            builder.setType(this.type);
        }
        return builder.build();
    }
}

