/*
 * Decompiled with CFR 0.152.
 */
package io.drdroid.api.models.kvs;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.drdroid.api.models.kvs.ArrayValues;
import io.drdroid.api.models.kvs.KeyValue;
import io.drdroid.api.models.kvs.KvValues;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Value {
    private String stringValue;
    private Boolean booleanValue;
    private Long longValue;
    private Double doubleValue;
    private Byte byteValue;
    private ArrayValues arrayValue;
    private KvValues keyValueList;

    public static Value newStringValue(String value) {
        Value typedValue = new Value();
        typedValue.setStringValue(value);
        return typedValue;
    }

    public static Value newBooleanValue(Boolean value) {
        Value typedValue = new Value();
        typedValue.setBooleanValue(value);
        return typedValue;
    }

    public static Value newLongValue(Long value) {
        Value typedValue = new Value();
        typedValue.setLongValue(value);
        return typedValue;
    }

    public static Value newDoubleValue(Double value) {
        Value typedValue = new Value();
        typedValue.setDoubleValue(value);
        return typedValue;
    }

    public static Value newArrayValue(List<Value> value) {
        Value typedValue = new Value();
        typedValue.setArrayValue(value);
        return typedValue;
    }

    public static Value newKvValueList(List<KeyValue> value) {
        Value typedValue = new Value();
        typedValue.setKeyValueList(value);
        return typedValue;
    }

    @JsonGetter(value="string_value")
    public String getStringValue() {
        return this.stringValue;
    }

    @JsonSetter(value="string_value")
    public void setStringValue(String value) {
        this.stringValue = value;
    }

    @JsonGetter(value="bool_value")
    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    @JsonSetter(value="bool_value")
    public void setBooleanValue(Boolean value) {
        this.booleanValue = value;
    }

    @JsonGetter(value="int_value")
    public Long getLongValue() {
        return this.longValue;
    }

    @JsonSetter(value="int_value")
    public void setLongValue(Long value) {
        this.longValue = value;
    }

    @JsonGetter(value="double_value")
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @JsonSetter(value="double_value")
    public void setDoubleValue(Double value) {
        this.doubleValue = value;
    }

    @JsonGetter(value="array_value")
    public ArrayValues getArrayValue() {
        return this.arrayValue;
    }

    @JsonSetter(value="array_value")
    public void setArrayValue(List<Value> arrayValue) {
        this.arrayValue = new ArrayValues(arrayValue);
    }

    @JsonGetter(value="kvlist_value")
    public KvValues getKeyValueList() {
        return this.keyValueList;
    }

    @JsonSetter(value="kvlist_value")
    public void setKeyValueList(List<KeyValue> keyValueList) {
        this.keyValueList = new KvValues(keyValueList);
    }

    @JsonGetter(value="bytes_value")
    public Byte getByteValue() {
        return this.byteValue;
    }

    @JsonSetter(value="bytes_value")
    public void setByteValue(Byte value) {
        this.byteValue = value;
    }
}

