/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class HttpReply {
    private int status;
    private Map<String, String> headers = new HashMap<String, String>();
    private InputStream content;

    private HttpReply(int status, InputStream content, Map<String, String> headers) {
        if (content == null) {
            throw new IllegalArgumentException("HttpReply content must not be null");
        }
        if (headers == null) {
            throw new IllegalArgumentException("HttpReply headers must not be null");
        }
        this.status = status;
        this.content = content;
        this.headers.putAll(headers);
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String toString() {
        return "HttpReply{status=" + this.status + ", headers=" + this.headers + ", content=" + this.content + '}';
    }

    public static enum Status {
        OK(200, "OK"),
        CREATED(201, "Created"),
        ACCEPTED(202, "Accepted"),
        NO_CONTENT(204, "No Content"),
        RESET_CONTENT(205, "Reset Content"),
        PARTIAL_CONTENT(206, "Partial Content"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        FOUND(302, "Found"),
        SEE_OTHER(303, "See Other"),
        NOT_MODIFIED(304, "Not Modified"),
        USE_PROXY(305, "Use Proxy"),
        TEMPORARY_REDIRECT(307, "Temporary Redirect"),
        BAD_REQUEST(400, "Bad Request"),
        UNAUTHORIZED(401, "Unauthorized"),
        PAYMENT_REQUIRED(402, "Payment Required"),
        FORBIDDEN(403, "Forbidden"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        NOT_ACCEPTABLE(406, "Not Acceptable"),
        PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
        REQUEST_TIMEOUT(408, "Request Timeout"),
        CONFLICT(409, "Conflict"),
        GONE(410, "Gone"),
        LENGTH_REQUIRED(411, "Length Required"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
        REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
        EXPECTATION_FAILED(417, "Expectation Failed"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented"),
        BAD_GATEWAY(502, "Bad Gateway"),
        SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        GATEWAY_TIMEOUT(504, "Gateway Timeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported");

        private final int code;
        private final String reason;

        private Status(int statusCode, String reason) {
            this.code = statusCode;
            this.reason = reason;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReason() {
            return this.toString();
        }

        public String toString() {
            return "Status{code=" + this.code + ", reason='" + this.reason + '\'' + '}';
        }

        public static Status fromStatusCode(int statusCode) {
            for (Status s : Status.values()) {
                if (s.code != statusCode) continue;
                return s;
            }
            return null;
        }
    }

    public static final class Builder {
        private int status;
        private InputStream content;
        private Map<String, String> headers = new HashMap<String, String>();

        public Builder status(int statusCode) {
            this.status = statusCode;
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder content(InputStream content) {
            if (content == null) {
                throw new IllegalArgumentException("Content must not be null");
            }
            this.content = content;
            return this;
        }

        public Builder status(Status status) {
            if (status == null) {
                throw new IllegalArgumentException("Status must not be null");
            }
            return this.status(status.getStatusCode());
        }

        public HttpReply build() {
            return new HttpReply(this.status, this.content, this.headers);
        }
    }
}

