/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.httpserver.H2Options;

public final class H2OptionsConfigure {
    private boolean enabled;
    private int maxReservedStreams;
    private int maxFrameSize;
    private long gracefulShutdownTimeoutMillis = 60000L;

    private H2OptionsConfigure() {
    }

    public static H2OptionsConfigure newOpts() {
        return new H2OptionsConfigure();
    }

    public H2OptionsConfigure enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public H2OptionsConfigure maxReservedStreams(int maxReservedStreams) {
        this.maxReservedStreams = maxReservedStreams;
        return this;
    }

    public H2OptionsConfigure maxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public H2OptionsConfigure gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        this.gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
        return this;
    }

    public H2Options configured() {
        H2Options h2Options = new H2Options();
        h2Options.setEnabled(this.enabled);
        h2Options.setMaxReservedStreams(this.maxReservedStreams);
        h2Options.setMaxFrameSize(this.maxFrameSize);
        h2Options.setGracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis);
        return h2Options;
    }
}

