/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.httpserver.ServerOptions;
import esa.httpserver.ServerOptionsConfigure;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.HttpServerImpl;
import esa.httpserver.metrics.Metrics;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.function.Consumer;

public interface HttpServer {
    public static HttpServer create() {
        return HttpServer.create(ServerOptionsConfigure.newOpts().configured());
    }

    public static HttpServer create(ServerOptions options) {
        return new HttpServerImpl(options);
    }

    public static HttpServer create(String name, ServerOptions options) {
        return new HttpServerImpl(name, options);
    }

    public HttpServer handle(Consumer<RequestHandle> var1);

    public HttpServer onConnected(Consumer<ChannelHandlerContext> var1);

    public HttpServer onDisconnected(Consumer<Channel> var1);

    public HttpServer onClose(Runnable var1);

    public HttpServer listen(int var1);

    public HttpServer listen(String var1, int var2);

    public HttpServer listen(SocketAddress var1);

    public String name();

    public void await() throws InterruptedException;

    public void awaitUninterruptibly();

    public Future<Void> closeFuture();

    public EventLoopGroup bossGroup();

    public EventLoopGroup ioGroup();

    public SocketAddress address();

    public Metrics metrics();

    public void close();
}

